---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：157-CameraHelper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/helpers/CameraHelper.js` 1-346行目（メイン実装）
- E-02: `src/cameras/Camera.js`（カメラ基底クラス）
- E-03: `src/objects/LineSegments.js`（親クラス実装）
- E-04: `src/core/BufferGeometry.js`（ジオメトリ管理）
- E-05: `src/math/Vector3.js`（ベクトル演算）
- E-06: `src/math/Color.js`（色管理）
- E-07: `src/constants.js`（座標系定数）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CameraHelperはLineSegmentsを継承 | E-01 (32行目: `class CameraHelper extends LineSegments`) | ○ |
| C-02 | カメラを引数に受け取る | E-01 (39行目: `constructor( camera )`) | ○ |
| C-03 | pointMapで頂点インデックス管理 | E-01 (47行目: `const pointMap = {}`) | ○ |
| C-04 | ニア面4線分定義 | E-01 (51-54行目: n1-n2, n2-n4, n4-n3, n3-n1) | ○ |
| C-05 | ファー面4線分定義 | E-01 (58-61行目: f1-f2, f2-f4, f4-f3, f3-f1) | ○ |
| C-06 | 側面4線分定義 | E-01 (65-68行目: n1-f1, n2-f2, n3-f3, n4-f4) | ○ |
| C-07 | コーン4線分定義 | E-01 (72-75行目: p-n1, p-n2, p-n3, p-n4) | ○ |
| C-08 | 上方向3線分定義 | E-01 (79-81行目: u1-u2, u2-u3, u3-u1) | ○ |
| C-09 | typeは'CameraHelper' | E-01 (123行目: `this.type = 'CameraHelper'`) | ○ |
| C-10 | cameraプロパティ保存 | E-01 (130行目: `this.camera = camera`) | ○ |
| C-11 | matrixを共有 | E-01 (133行目: `this.matrix = camera.matrixWorld`) | ○ |
| C-12 | matrixAutoUpdate = false | E-01 (134行目: `this.matrixAutoUpdate = false`) | ○ |
| C-13 | update()を呼び出す | E-01 (143行目: `this.update()`) | ○ |
| C-14 | setColors()でデフォルト色設定 | E-01 (147-153行目) | ○ |
| C-15 | colorFrustum = 0xffaa00 | E-01 (147行目: `new Color( 0xffaa00 )`) | ○ |
| C-16 | colorCone = 0xff0000 | E-01 (148行目: `new Color( 0xff0000 )`) | ○ |
| C-17 | colorUp = 0x00aaff | E-01 (149行目: `new Color( 0x00aaff )`) | ○ |
| C-18 | setColors引数で色変更可能 | E-01 (167-224行目: setColorsメソッド) | ○ |
| C-19 | update()でprojectionMatrixInverse使用 | E-01 (241行目: `_camera.projectionMatrixInverse.copy`) | ○ |
| C-20 | reversedDepth対応 | E-01 (245-248行目: reversedDepth判定) | ○ |
| C-21 | WebGL座標系対応 nearZ=-1 | E-01 (252-255行目) | ○ |
| C-22 | WebGPU座標系対応 nearZ=0 | E-01 (257-260行目) | ○ |
| C-23 | 無効座標系でエラー | E-01 (264行目: `throw new Error`) | ○ |
| C-24 | disposeでgeometry/material解放 | E-01 (315-319行目) | ○ |
| C-25 | Menubar - Viewでヘルパー表示切替 | E-09 (70行目: 画面No14, CameraHelper, 補助機能) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [x] クラス継承関係が正しく記載されているか
- [x] pointMapの構造と線分定義が正確か
- [x] setColors()の色定義が実装と一致しているか
- [x] update()の座標系判定ロジックが正確か
- [x] 画面機能マッピングとの整合性があるか
