---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：158-DirectionalLightHelper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/helpers/DirectionalLightHelper.js` 1-149行目（メイン実装）
- E-02: `src/lights/DirectionalLight.js`（対象光源）
- E-03: `src/core/Object3D.js`（親クラス実装）
- E-04: `src/objects/Line.js`（子要素）
- E-05: `src/core/BufferGeometry.js`（ジオメトリ管理）
- E-06: `src/materials/LineBasicMaterial.js`（マテリアル）
- E-07: `src/math/Vector3.js`（ベクトル演算）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectionalLightHelperはObject3Dを継承 | E-01 (30行目: `class DirectionalLightHelper extends Object3D`) | ○ |
| C-02 | light, size, colorを引数に受け取る | E-01 (40行目: `constructor( light, size, color )`) | ○ |
| C-03 | lightプロパティ保存 | E-01 (49行目: `this.light = light`) | ○ |
| C-04 | matrixWorld共有 | E-01 (51行目: `this.matrix = light.matrixWorld`) | ○ |
| C-05 | matrixAutoUpdate = false | E-01 (52行目: `this.matrixAutoUpdate = false`) | ○ |
| C-06 | colorプロパティ保存 | E-01 (60行目: `this.color = color`) | ○ |
| C-07 | typeは'DirectionalLightHelper' | E-01 (62行目: `this.type = 'DirectionalLightHelper'`) | ○ |
| C-08 | size未指定時は1 | E-01 (64行目: `if ( size === undefined ) size = 1`) | ○ |
| C-09 | lightPlane頂点は5つ | E-01 (66-73行目: 5頂点の配列) | ○ |
| C-10 | fog: false設定 | E-01 (75行目: `fog: false`) | ○ |
| C-11 | toneMapped: false設定 | E-01 (75行目: `toneMapped: false`) | ○ |
| C-12 | lightPlaneプロパティ保存 | E-01 (82行目: `this.lightPlane = new Line`) | ○ |
| C-13 | this.addでlightPlane追加 | E-01 (83行目: `this.add( this.lightPlane )`) | ○ |
| C-14 | targetLine頂点は2つ | E-01 (86行目: `[ 0, 0, 0, 0, 0, 1 ]`) | ○ |
| C-15 | targetLineプロパティ保存 | E-01 (93行目: `this.targetLine = new Line`) | ○ |
| C-16 | コンストラクタでupdate呼び出し | E-01 (96行目: `this.update()`) | ○ |
| C-17 | update()でlight.updateWorldMatrix | E-01 (119行目: `this.light.updateWorldMatrix`) | ○ |
| C-18 | update()でtarget.updateWorldMatrix | E-01 (120行目: `this.light.target.updateWorldMatrix`) | ○ |
| C-19 | lightPlane.lookAt(target) | E-01 (126行目: `this.lightPlane.lookAt( _v2 )`) | ○ |
| C-20 | targetLine.scale.z = 距離 | E-01 (141行目: `this.targetLine.scale.z = _v3.length()`) | ○ |
| C-21 | disposeで4つのリソース解放 | E-01 (104-109行目) | ○ |
| C-22 | Menubar - Viewでヘルパー表示切替 | E-09 (71行目: 画面No14, DirectionalLightHelper, 補助機能) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [x] クラス継承関係（Object3D継承）が正しく記載されているか
- [x] コンストラクタパラメータとデフォルト値が正確か
- [x] lightPlaneとtargetLineの構造が正確か
- [x] update()のロジック（位置取得、lookAt、スケール）が正確か
- [x] 画面機能マッピングとの整合性があるか
