---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：159-SpotLightHelper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/helpers/SpotLightHelper.js` 1-155行目（メイン実装）
- E-02: `src/lights/SpotLight.js`（対象光源）
- E-03: `src/core/Object3D.js`（親クラス実装）
- E-04: `src/objects/LineSegments.js`（子要素）
- E-05: `src/core/BufferGeometry.js`（ジオメトリ管理）
- E-06: `src/materials/LineBasicMaterial.js`（マテリアル）
- E-07: `src/math/Vector3.js`（ベクトル演算）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SpotLightHelperはObject3Dを継承 | E-01 (27行目: `class SpotLightHelper extends Object3D`) | ○ |
| C-02 | light, colorを引数に受け取る | E-01 (36行目: `constructor( light, color )`) | ○ |
| C-03 | lightプロパティ保存 | E-01 (45行目: `this.light = light`) | ○ |
| C-04 | matrixAutoUpdate = false | E-01 (47行目: `this.matrixAutoUpdate = false`) | ○ |
| C-05 | colorプロパティ保存 | E-01 (55行目: `this.color = color`) | ○ |
| C-06 | typeは'SpotLightHelper' | E-01 (57行目: `this.type = 'SpotLightHelper'`) | ○ |
| C-07 | 放射線5本の頂点定義 | E-01 (61-67行目: 5本の放射線定義) | ○ |
| C-08 | 円周32セグメント | E-01 (69行目: `l = 32`) | ○ |
| C-09 | fog: false設定 | E-01 (83行目: `fog: false`) | ○ |
| C-10 | toneMapped: false設定 | E-01 (83行目: `toneMapped: false`) | ○ |
| C-11 | coneプロパティ保存 | E-01 (85行目: `this.cone = new LineSegments`) | ○ |
| C-12 | this.addでcone追加 | E-01 (86行目: `this.add( this.cone )`) | ○ |
| C-13 | コンストラクタでupdate呼び出し | E-01 (88行目: `this.update()`) | ○ |
| C-14 | update()でlight.updateWorldMatrix | E-01 (109行目: `this.light.updateWorldMatrix`) | ○ |
| C-15 | update()でtarget.updateWorldMatrix | E-01 (110行目: `this.light.target.updateWorldMatrix`) | ○ |
| C-16 | 親オブジェクト考慮のロジック | E-01 (113-126行目) | ○ |
| C-17 | coneLength計算: distance or 1000 | E-01 (130行目: `this.light.distance ? this.light.distance : 1000`) | ○ |
| C-18 | coneWidth計算: length × tan(angle) | E-01 (131行目: `coneLength * Math.tan( this.light.angle )`) | ○ |
| C-19 | cone.scale設定 | E-01 (133行目: `this.cone.scale.set`) | ○ |
| C-20 | cone.lookAt(target) | E-01 (137行目: `this.cone.lookAt( _vector )`) | ○ |
| C-21 | disposeでgeometry/material解放 | E-01 (98-99行目) | ○ |
| C-22 | 機能名はSpotLightHelperである | E-08 (160行目: `"159","ヘルパー","SpotLightHelper"`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [x] クラス継承関係（Object3D継承）が正しく記載されているか
- [x] コンストラクタパラメータが正確か
- [x] 放射線と円周の構造が正確か
- [x] update()のロジック（coneLength/Width、親考慮）が正確か
- [x] tan(angle)による円錐幅計算が正確か
