---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：162-SkeletonHelper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/helpers/SkeletonHelper.js` (1-195行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (163行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (118行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SkeletonHelperはLineSegmentsを継承する | E-01 (23行目: `class SkeletonHelper extends LineSegments`) | ○ |
| C-02 | getBoneList関数でボーンを再帰的に取得 | E-01 (173-191行目) | ○ |
| C-03 | isBone === true でボーンを判定 | E-01 (177行目: `if ( object.isBone === true )`) | ○ |
| C-04 | 親がボーンの場合のみ線分を描画 | E-01 (44行目: `if ( bone.parent && bone.parent.isBone )`) | ○ |
| C-05 | LineBasicMaterialを使用 | E-01 (58行目: `new LineBasicMaterial`) | ○ |
| C-06 | vertexColors: trueを設定 | E-01 (58行目) | ○ |
| C-07 | depthTest: falseを設定 | E-01 (58行目) | ○ |
| C-08 | depthWrite: falseを設定 | E-01 (58行目) | ○ |
| C-09 | transparent: trueを設定 | E-01 (58行目) | ○ |
| C-10 | isSkeletonHelper = trueを設定 | E-01 (69行目) | ○ |
| C-11 | this.rootにオブジェクト参照を保存 | E-01 (78行目: `this.root = object`) | ○ |
| C-12 | this.bonesにボーンリストを保存 | E-01 (85行目: `this.bones = bones`) | ○ |
| C-13 | 行列をルートのmatrixWorldと同期 | E-01 (87行目: `this.matrix = object.matrixWorld`) | ○ |
| C-14 | matrixAutoUpdate = false | E-01 (88行目) | ○ |
| C-15 | デフォルト色は青(0x0000ff)と緑(0x00ff00) | E-01 (92-95行目) | ○ |
| C-16 | updateMatrixWorldでボーン位置を更新 | E-01 (99-132行目) | ○ |
| C-17 | ルートの逆行列を計算 | E-01 (106行目: `_matrixWorldInv.copy( this.root.matrixWorld ).invert()`) | ○ |
| C-18 | setColorsで色をカスタマイズ可能 | E-01 (141-157行目) | ○ |
| C-19 | dispose()でジオメトリとマテリアルを解放 | E-01 (163-168行目) | ○ |
| C-20 | Bones Browserで主機能として使用 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] getBoneList関数の再帰処理が正確に説明されているか確認
- [ ] updateMatrixWorldの行列計算が正確か確認
- [ ] setColorsメソッドの動作が正確に記述されているか確認
