---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：163-Curve

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/extras/core/Curve.js` (1-517行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (164行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Curveは曲線の抽象基底クラス | E-01 (13行目: `class Curve`) | ○ |
| C-02 | type = 'Curve' | E-01 (27行目) | ○ |
| C-03 | arcLengthDivisionsのデフォルトは200 | E-01 (38行目: `this.arcLengthDivisions = 200`) | ○ |
| C-04 | needsUpdateプロパティでキャッシュ制御 | E-01 (46行目: `this.needsUpdate = false`) | ○ |
| C-05 | cacheArcLengthsにキャッシュを保存 | E-01 (55行目: `this.cacheArcLengths = null`) | ○ |
| C-06 | getPoint()は抽象メソッドで警告を出す | E-01 (68-72行目: `warn( 'Curve: .getPoint() not implemented.' )`) | ○ |
| C-07 | getPointAt()はgetUtoTmappingを使用 | E-01 (85行目: `const t = this.getUtoTmapping( u )`) | ○ |
| C-08 | getPoints()はdivisions+1個の点を返す | E-01 (97-109行目) | ○ |
| C-09 | getSpacedPoints()は等距離サンプリング | E-01 (121-133行目) | ○ |
| C-10 | getLength()は最後の累積長を返す | E-01 (142-143行目: `return lengths[ lengths.length - 1 ]`) | ○ |
| C-11 | getLengths()はキャッシュを再利用 | E-01 (155-160行目) | ○ |
| C-12 | updateArcLengths()でキャッシュを更新 | E-01 (192-197行目: `this.needsUpdate = true`) | ○ |
| C-13 | getUtoTmapping()は二分探索を使用 | E-01 (229-254行目) | ○ |
| C-14 | getTangent()はdelta=0.0001で近似 | E-01 (295行目: `const delta = 0.0001`) | ○ |
| C-15 | t1, t2を0〜1にクランプ | E-01 (301-302行目) | ○ |
| C-16 | computeFrenetFrames()はTubeGeometry等で使用 | E-01 (332-333行目: JSDocコメント) | ○ |
| C-17 | 最小成分方向に初期法線を設定 | E-01 (366-389行目) | ○ |
| C-18 | 閉曲線の場合は最初と最後を接続 | E-01 (423-441行目: `if ( closed === true )`) | ○ |
| C-19 | clone()はコンストラクタとcopy()を使用 | E-01 (457-461行目) | ○ |
| C-20 | toJSON()はmetadataを含む | E-01 (483-497行目) | ○ |
| C-21 | fromJSON()でデシリアライズ | E-01 (506-512行目) | ○ |
| C-22 | 機能説明「曲線の基底クラス」 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] getUtoTmapping()の二分探索ロジックが正確に説明されているか確認
- [ ] computeFrenetFrames()の法線・従法線計算が正確か確認
- [ ] 抽象メソッドとしてのgetPoint()の役割が明確か確認
