---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：164-CurvePath

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/extras/core/CurvePath.js` (1-297行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (165行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CurvePathはCurveを継承 | E-01 (10行目: `class CurvePath extends Curve`) | ○ |
| C-02 | type = 'CurvePath' | E-01 (19行目) | ○ |
| C-03 | curvesプロパティで曲線配列を保持 | E-01 (27行目: `this.curves = []`) | ○ |
| C-04 | autoCloseプロパティでパス自動クローズ | E-01 (36行目: `this.autoClose = false`) | ○ |
| C-05 | add()でcurves配列にpush | E-01 (47行目: `this.curves.push( curve )`) | ○ |
| C-06 | closePath()で開始点と終了点が異なる場合に線を追加 | E-01 (62行目: `if ( ! startPoint.equals( endPoint ) )`) | ○ |
| C-07 | Vector2ならLineCurve、そうでなければLineCurve3 | E-01 (64行目) | ○ |
| C-08 | getPoint()でパス全体の距離を計算 | E-01 (92行目: `const d = t * this.getLength()`) | ○ |
| C-09 | 累積長で対象曲線を特定 | E-01 (98-114行目) | ○ |
| C-10 | u = 1 - diff / segmentLengthで曲線内パラメータ計算 | E-01 (106行目) | ○ |
| C-11 | getLength()はgetCurveLengths()を使用 | E-01 (128行目) | ○ |
| C-12 | cacheLengthsに曲線長をキャッシュ | E-01 (154行目) | ○ |
| C-13 | needsUpdate時にキャッシュを再計算 | E-01 (133-139行目) | ○ |
| C-14 | getSpacedPointsはdivisions=40がデフォルト | E-01 (179行目) | ○ |
| C-15 | autoCloseで終点を追加 | E-01 (189-193行目) | ○ |
| C-16 | getPointsはdivisions=12がデフォルト | E-01 (199行目) | ○ |
| C-17 | 曲線タイプに応じた分割数で適応的サンプリング | E-01 (206-210行目) | ○ |
| C-18 | last.equals(point)で重複点を除去 | E-01 (218行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] getPoint()の曲線特定ロジックが正確か確認
- [ ] closePath()の曲線タイプ判定が正確か確認
- [ ] getPoints()の適応的分割が正確に説明されているか確認
