---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：167-ShapePath

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/extras/core/ShapePath.js` (1-368行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (168行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShapePathはPathを管理するクラス | E-01 (10行目: `class ShapePath`) | ○ |
| C-02 | type = 'ShapePath' | E-01 (17行目) | ○ |
| C-03 | colorプロパティで色を管理 | E-01 (24行目: `this.color = new Color()`) | ○ |
| C-04 | subPathsでサブパス配列を管理 | E-01 (32行目: `this.subPaths = []`) | ○ |
| C-05 | currentPathで現在のパスを管理 | E-01 (40行目: `this.currentPath = null`) | ○ |
| C-06 | moveTo()で新しいPathを作成 | E-01 (53行目: `this.currentPath = new Path()`) | ○ |
| C-07 | moveTo()でsubPathsに追加 | E-01 (54行目: `this.subPaths.push( this.currentPath )`) | ○ |
| C-08 | lineTo()はcurrentPathに委譲 | E-01 (71行目: `this.currentPath.lineTo( x, y )`) | ○ |
| C-09 | quadraticCurveTo()はcurrentPathに委譲 | E-01 (89行目) | ○ |
| C-10 | bezierCurveTo()はcurrentPathに委譲 | E-01 (109行目) | ○ |
| C-11 | splineThru()はcurrentPathに委譲 | E-01 (124行目) | ○ |
| C-12 | toShapes()でShape配列に変換 | E-01 (137-362行目) | ○ |
| C-13 | ShapeUtils.isClockWiseで巻き方向判定 | E-01 (218行目) | ○ |
| C-14 | subPathsが空なら空配列を返却 | E-01 (221行目) | ○ |
| C-15 | 単一サブパスはそのままShapeに変換 | E-01 (226-233行目) | ○ |
| C-16 | isPointInsidePolygon()で包含判定 | E-01 (158-216行目) | ○ |
| C-17 | 穴を対応するShapeに割り当て | E-01 (283-340行目) | ○ |
| C-18 | 機能説明「SVGパスのような複合シェイプ」 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] toShapes()の巻き方向判定ロジックが正確か確認
- [ ] isPointInsidePolygon()のレイキャスティング法が正確か確認
- [ ] 穴の割り当てアルゴリズムが正確に説明されているか確認
