---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：168-PMREMGenerator

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/extras/PMREMGenerator.js` (1-1167行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (169行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (14行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LOD_MIN = 4 | E-01 (27行目: `const LOD_MIN = 4`) | ○ |
| C-02 | GGX_SAMPLES = 256 | E-01 (39行目: `const GGX_SAMPLES = 256`) | ○ |
| C-03 | MAX_SAMPLES = 20（ブラー用） | E-01 (36行目: `const MAX_SAMPLES = 20`) | ○ |
| C-04 | コンストラクタでrenderer参照を保存 | E-01 (75行目: `this._renderer = renderer`) | ○ |
| C-05 | fromScene()でシーンからPMREM生成 | E-01 (109-141行目) | ○ |
| C-06 | fromScene()のデフォルトsize=256 | E-01 (112行目: `size = 256`) | ○ |
| C-07 | sigma > 0でブラーを適用 | E-01 (130-134行目: `if ( sigma > 0 )`) | ○ |
| C-08 | fromEquirectangular()でEquirectangularからPMREM生成 | E-01 (152-156行目) | ○ |
| C-09 | fromCubemap()でキューブマップからPMREM生成 | E-01 (167-171行目) | ○ |
| C-10 | compileCubemapShader()で事前コンパイル | E-01 (177-186行目) | ○ |
| C-11 | compileEquirectangularShader()で事前コンパイル | E-01 (192-201行目) | ○ |
| C-12 | dispose()で内部リソース解放 | E-01 (208-222行目) | ○ |
| C-13 | _allocateTargets()でレンダーターゲット確保 | E-01 (286-323行目) | ○ |
| C-14 | HalfFloatTypeでレンダーターゲット作成 | E-01 (295行目: `type: HalfFloatType`) | ○ |
| C-15 | _sceneToCubeUV()で6方向レンダリング | E-01 (332-442行目) | ○ |
| C-16 | _applyPMREM()でGGXフィルタリング | E-01 (488-505行目) | ○ |
| C-17 | _applyGGXFilter()でインクリメンタルラフネス計算 | E-01 (530-532行目) | ○ |
| C-18 | GGX VNDF重要度サンプリング（Heitz 2018） | E-01 (843-844行目: JSDocコメント) | ○ |
| C-19 | Hammersleyシーケンスでサンプル点生成 | E-01 (837-840行目) | ○ |
| C-20 | CubeUVフォーマットで出力 | E-01 (776-777行目: `cubeUVRenderTarget.texture.mapping = CubeUVReflectionMapping`) | ○ |
| C-21 | 機能説明「環境マップをPBR用に事前フィルタリング」 | E-02 | ○ |
| C-22 | Viewportで補助機能として使用 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] GGX VNDFフィルタリングの説明が正確か確認
- [ ] インクリメンタルラフネス計算が正確か確認
- [ ] fromScene/fromEquirectangular/fromCubemapの違いが明確か確認
