---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：169-Controls

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/extras/Controls.js` (1-121行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (170行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (108行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ControlsはEventDispatcherを継承 | E-01 (10行目: `class Controls extends EventDispatcher`) | ○ |
| C-02 | コンストラクタでobjectを保存 | E-01 (28行目: `this.object = object`) | ○ |
| C-03 | コンストラクタでdomElementを保存（デフォルトnull） | E-01 (35行目: `this.domElement = domElement`) | ○ |
| C-04 | enabledプロパティでコントロールの有効/無効 | E-01 (43行目: `this.enabled = true`) | ○ |
| C-05 | stateプロパティで内部状態管理（デフォルト-1） | E-01 (51行目: `this.state = - 1`) | ○ |
| C-06 | keysプロパティでキーボード入力設定 | E-01 (58行目: `this.keys = {}`) | ○ |
| C-07 | mouseButtonsプロパティでマウスボタン設定 | E-01 (66行目) | ○ |
| C-08 | touchesプロパティでタッチ入力設定 | E-01 (74行目) | ○ |
| C-09 | connect()でDOM要素を接続 | E-01 (84-97行目) | ○ |
| C-10 | connect()でelement未定義時に警告 | E-01 (86-89行目: `warn( 'Controls: connect() now requires an element.' )`) | ○ |
| C-11 | 既存接続があればdisconnect()を呼び出し | E-01 (93行目: `if ( this.domElement !== null ) this.disconnect()`) | ○ |
| C-12 | disconnect()は空のメソッド（抽象） | E-01 (102行目: `disconnect() {}`) | ○ |
| C-13 | dispose()は空のメソッド（抽象） | E-01 (108行目: `dispose() {}`) | ○ |
| C-14 | update()は空のメソッド（抽象） | E-01 (116行目: `update( /* delta */ ) {}`) | ○ |
| C-15 | update()にdelta引数（コメントアウト） | E-01 (116行目) | ○ |
| C-16 | 抽象基底クラスとしての設計 | E-01 (7-8行目: JSDocコメント `@abstract`) | ○ |
| C-17 | 機能説明「カメラコントロールの基底クラス」 | E-02 | ○ |
| C-18 | その他サンプルで主機能として使用 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 抽象メソッドの役割が明確に説明されているか確認
- [ ] connect/disconnect/dispose/updateの関係が正確か確認
- [ ] プロパティのデフォルト値が正確か確認
