---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-PostProcessing

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/common/PostProcessing.js` 1-29行目
- E-02: `src/renderers/common/RenderPipeline.js` 1-227行目
- E-03: `src/renderers/common/QuadMesh.js`（参照）
- E-04: `src/materials/nodes/NodeMaterial.js`（参照）
- E-05: `機能一覧.csv` 17行目
- E-06: `画面機能マッピング.csv` 13行目, 22行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PostProcessingはRenderPipelineにリネームされた非推奨クラス | E-01 (5-7行目コメント) | ○ |
| C-02 | PostProcessingはRenderPipelineを継承 | E-01 (9行目) | ○ |
| C-03 | コンストラクタで非推奨警告をwarnOnceで出力 | E-01 (20行目) | ○ |
| C-04 | RenderPipelineでrendererとoutputNodeを受け取る | E-02 (30行目) | ○ |
| C-05 | outputNodeのデフォルトはvec4(0,0,1,1) | E-02 (30行目) | ○ |
| C-06 | rendererプロパティでレンダラー参照を保持 | E-02 (37行目) | ○ |
| C-07 | outputNodeプロパティでエフェクトチェーン終端を設定 | E-02 (46行目) | ○ |
| C-08 | outputColorTransformでトーンマッピング/色空間変換を制御 | E-02 (66行目) | ○ |
| C-09 | needsUpdateプロパティで更新フラグを管理 | E-02 (73行目) | ○ |
| C-10 | NodeMaterialを作成してQuadMeshに設定 | E-02 (75-86行目) | ○ |
| C-11 | render()メソッドでエフェクト適用と描画 | E-02 (104行目) | ○ |
| C-12 | render()でトーンマッピングを一時無効化 | E-02 (115-116行目) | ○ |
| C-13 | render()でXRを一時無効化 | E-02 (120-121行目) | ○ |
| C-14 | _quadMesh.render()でフルスクリーン描画 | E-02 (123行目) | ○ |
| C-15 | _update()でノードグラフを構築 | E-02 (162行目) | ○ |
| C-16 | renderOutput()でトーンマッピングと色空間変換を適用 | E-02 (183行目) | ○ |
| C-17 | dispose()でmaterial.dispose()を呼び出す | E-02 (153行目) | ○ |
| C-18 | renderAsync()は非推奨でr181から警告 | E-02 (216行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PostProcessingとRenderPipelineの関係が正しく記述されているか確認
- [ ] 非推奨警告の内容が正しいか確認
- [ ] outputColorTransformの動作が正しく説明されているか確認
- [ ] 画面機能マッピングとの整合性確認
