---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：170-DataUtils

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/extras/DataUtils.js` (1-218行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` (171行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _generateTables()でルックアップテーブル生成 | E-01 (8-141行目) | ○ |
| C-02 | baseTable[512]を生成 | E-01 (16行目: `const baseTable = new Uint32Array( 512 )`) | ○ |
| C-03 | shiftTable[512]を生成 | E-01 (17行目: `const shiftTable = new Uint32Array( 512 )`) | ○ |
| C-04 | mantissaTable[2048]を生成 | E-01 (74行目: `const mantissaTable = new Uint32Array( 2048 )`) | ○ |
| C-05 | exponentTable[64]を生成 | E-01 (75行目: `const exponentTable = new Uint32Array( 64 )`) | ○ |
| C-06 | offsetTable[64]を生成 | E-01 (76行目: `const offsetTable = new Uint32Array( 64 )`) | ○ |
| C-07 | toHalfFloat()で65504を超えると警告 | E-01 (152行目: `if ( Math.abs( val ) > 65504 ) warn`) | ○ |
| C-08 | clamp()で-65504〜65504にクランプ | E-01 (154行目: `val = clamp( val, - 65504, 65504 )`) | ○ |
| C-09 | floatViewとuint32Viewでビット変換 | E-01 (156-157行目) | ○ |
| C-10 | 指数部を(f >> 23) & 0x1ffで抽出 | E-01 (158行目) | ○ |
| C-11 | baseTable[e] + シフト演算で結果を返却 | E-01 (159行目) | ○ |
| C-12 | fromHalfFloat()でval >> 10で指数部抽出 | E-01 (172行目: `const m = val >> 10`) | ○ |
| C-13 | mantissaTable + exponentTableで変換 | E-01 (173行目) | ○ |
| C-14 | DataUtilsは静的クラス | E-01 (183行目: `class DataUtils`) | ○ |
| C-15 | static toHalfFloat()メソッドを提供 | E-01 (192-194行目) | ○ |
| C-16 | static fromHalfFloat()メソッドを提供 | E-01 (205-207行目) | ○ |
| C-17 | toHalfFloatとfromHalfFloatを直接エクスポート | E-01 (213-216行目) | ○ |
| C-18 | 機能説明「データ変換ユーティリティ（Half Float等）」 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ルックアップテーブル生成ロジックが正確に説明されているか確認
- [ ] toHalfFloat/fromHalfFloatのビット操作が正確か確認
- [ ] 範囲チェックとクランプ処理が正確か確認
