---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：174-TSL機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **WebGPUでのWGSL生成の詳細**：WebGPUバックエンドの実装確認が必要
  2. **TSLBase.jsの実装詳細**：基本関数の実際の実装を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/nodes/TSL.js` 1-177行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 174行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 93行目（WebGPUサンプル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TSLはノードベースシェーダー言語 | E-01 (全体構造), E-02 | ○ |
| C-02 | TSL.jsは各種ノードをエクスポート | E-01 (1-177行目のexport文) | ○ |
| C-03 | コアノードをエクスポート（AssignNode等） | E-01 (5-18行目) | ○ |
| C-04 | 数学ノードをエクスポート（Hash等） | E-01 (22-28行目) | ○ |
| C-05 | ユーティリティノードをエクスポート | E-01 (31-50行目) | ○ |
| C-06 | TSLBaseをエクスポート | E-01 (53行目) | ○ |
| C-07 | アクセサノードをエクスポート | E-01 (56-93行目) | ○ |
| C-08 | ディスプレイノードをエクスポート | E-01 (96-115行目) | ○ |
| C-09 | ライティングノードをエクスポート | E-01 (140-147行目) | ○ |
| C-10 | BSDF関数をエクスポート | E-01 (163-177行目) | ○ |
| C-11 | BRDF_GGX関数が含まれる | E-01 (163行目) | ○ |
| C-12 | F_Schlick関数が含まれる | E-01 (167行目) | ○ |
| C-13 | GPGPU関連ノードをエクスポート | E-01 (132-137行目) | ○ |
| C-14 | PMREMノードをエクスポート | E-01 (150-151行目) | ○ |
| C-15 | MaterialXノードをエクスポート | E-01 (160行目) | ○ |
| C-16 | WebGPUサンプルで使用 | E-03 | ○ |
| C-17 | 機能一覧に「Three.js Shading Language」として登録 | E-02 | ○ |
| C-18 | TSLコードがGLSL/WGSLにコンパイルされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NodeBuilder.jsでのシェーダーコード生成プロセスの詳細
  - 候補：`src/nodes/core/NodeBuilder.js` / WebGPUBackendの実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TSL.jsのエクスポート構造は実装と一致
- 1: 中リスク - シェーダーコンパイルプロセスの詳細（外部モジュール依存）
- 0: 低リスク - 関連画面マッピング

## 6) レビュアーチェックリスト（最小）
- [ ] TSL.jsのエクスポート一覧がソースコードと一致するか確認
- [ ] TSLBase.jsの基本関数（float, vec2等）の実装を確認
- [ ] NodeBuilder.jsでのGLSL/WGSL生成プロセスを確認
- [ ] WebGPUサンプルでのTSL使用例を確認
