---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：175-NodeManager機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/common/nodes/NodeManager.js` 1-843行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 175行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 94行目（WebGPUサンプル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NodeManagerはDataMapを継承 | E-01 (25行目 extends DataMap) | ○ |
| C-02 | constructorでrendererとbackendを受け取る | E-01 (33-36行目) | ○ |
| C-03 | nodeFrameでフレーム更新を管理 | E-01 (56行目) | ○ |
| C-04 | nodeBuilderCacheでステートをキャッシュ | E-01 (63行目) | ○ |
| C-05 | callHashCacheでキャッシュキーを管理 | E-01 (70行目) | ○ |
| C-06 | groupsDataでユニフォームグループを管理 | E-01 (77行目) | ○ |
| C-07 | objectGroupは常にtrue | E-01 (102行目) | ○ |
| C-08 | renderGroupはrenderIdで判定 | E-01 (106-121行目) | ○ |
| C-09 | frameGroupはframeIdで判定 | E-01 (125-140行目) | ○ |
| C-10 | その他のグループはversionで判定 | E-01 (144-161行目) | ○ |
| C-11 | getForRenderでNodeBuilderStateを取得 | E-01 (183-249行目) | ○ |
| C-12 | キャッシュキーはinitialCacheKeyを使用 | E-01 (171-175行目) | ○ |
| C-13 | NodeBuilderを作成してbuild実行 | E-01 (199-233行目) | ○ |
| C-14 | ビルドエラー時はNodeMaterialでリビルド | E-01 (226-233行目) | ○ |
| C-15 | getForComputeでコンピュートノード用ステートを取得 | E-01 (282-301行目) | ○ |
| C-16 | getEnvironmentNodeで環境ノードを取得 | E-01 (334-358行目) | ○ |
| C-17 | getFogNodeでフォグノードを取得 | E-01 (399-405行目) | ○ |
| C-18 | getBackgroundNodeで背景ノードを取得 | E-01 (367-391行目) | ○ |
| C-19 | updateBackgroundで背景をノードに変換 | E-01 (473-535行目) | ○ |
| C-20 | updateFogでフォグをノードに変換 | E-01 (570-616行目) | ○ |
| C-21 | usedTimesで参照カウント | E-01 (241行目, 262行目) | ○ |
| C-22 | 機能一覧に「ノードシステムの管理クラス」として登録 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主要機能が実装と一致
- 0: 低リスク - キャッシュ管理ロジックの記述
- 0: 低リスク - エラーハンドリングの記述

## 6) レビュアーチェックリスト（最小）
- [ ] updateGroupのグループ名分岐がソースコードと一致するか確認
- [ ] getForRenderのキャッシュ管理フローがソースコードと一致するか確認
- [ ] updateBackground/updateFogのノード変換ロジックを確認
- [ ] ビルドエラー時のフォールバック処理を確認
