---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：177-WebXRController機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/webxr/WebXRController.js` 1-429行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 177行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 99行目（WebXRサンプル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebXRControllerは3つの座標空間を管理 | E-01 (27-47行目のプロパティ定義) | ○ |
| C-02 | _targetRay, _grip, _handはnullで初期化 | E-01 (27, 37, 47行目) | ○ |
| C-03 | getTargetRaySpaceで遅延初期化 | E-01 (78-93行目) | ○ |
| C-04 | getGripSpaceで遅延初期化 | E-01 (101-116行目) | ○ |
| C-05 | getHandSpaceで遅延初期化、joints辞書追加 | E-01 (56-70行目) | ○ |
| C-06 | matrixAutoUpdate=falseで初期化 | E-01 (61, 83, 106行目) | ○ |
| C-07 | linearVelocity/angularVelocityを追加 | E-01 (85-88, 108-111行目) | ○ |
| C-08 | dispatchEventで3空間にイベント伝播 | E-01 (126-148行目) | ○ |
| C-09 | connectでハンド関節を初期化 | E-01 (158-173行目) | ○ |
| C-10 | disconnectでvisible=false設定 | E-01 (191-207行目) | ○ |
| C-11 | updateでvisible-blurred状態をチェック | E-01 (233行目) | ○ |
| C-12 | ハンドトラッキングで各関節のポーズを更新 | E-01 (239-258行目) | ○ |
| C-13 | ピンチ検出の閾値0.02m, 0.005m | E-01 (267-268行目) | ○ |
| C-14 | ピンチ開始/終了でイベント発火 | E-01 (270-288行目) | ○ |
| C-15 | グリップ空間のポーズ更新 | E-01 (292-326行目) | ○ |
| C-16 | target ray空間のポーズ更新 | E-01 (330-372行目) | ○ |
| C-17 | gripPoseへのフォールバック | E-01 (335-339行目) | ○ |
| C-18 | moveイベント発火 | E-01 (369行目) | ○ |
| C-19 | _getHandJointで関節Groupを遅延作成 | E-01 (408-423行目) | ○ |
| C-20 | 機能一覧に「WebXRコントローラーの管理」として登録 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主要機能が実装と一致
- 0: 低リスク - ピンチ検出ロジックの記述
- 0: 低リスク - イベント処理の記述

## 6) レビュアーチェックリスト（最小）
- [ ] 3つの座標空間（targetRay, grip, hand）の初期化ロジックを確認
- [ ] updateメソッドのハンドトラッキング処理を確認
- [ ] ピンチジェスチャー検出の閾値と条件を確認
- [ ] visible-blurred状態の除外処理を確認
