---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：178-XRManager機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/common/XRManager.js` 1-1678行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 178行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 100行目（WebXRサンプル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XRManagerはEventDispatcherを継承 | E-01 (32行目 extends EventDispatcher) | ○ |
| C-02 | コンストラクタでrendererとmultiviewを受け取る | E-01 (40行目) | ○ |
| C-03 | enabledプロパティでXRを有効化 | E-01 (50行目) | ○ |
| C-04 | isPresentingでプレゼンテーション状態を示す | E-01 (59行目) | ○ |
| C-05 | _cameraL/_cameraRでステレオカメラを管理 | E-01 (85-95行目) | ○ |
| C-06 | _cameraXRはArrayCamera | E-01 (111行目) | ○ |
| C-07 | _controllersでWebXRControllerを管理 | E-01 (137行目) | ○ |
| C-08 | setSessionでWebGPUバックエンドをチェック | E-01 (931行目) | ○ |
| C-09 | XRProjectionLayerとXRWebGLLayerのフォールバック | E-01 (953-1075行目) | ○ |
| C-10 | デフォルト参照空間は'local-floor' | E-01 (290行目) | ○ |
| C-11 | マルチビューはOVR_multiview2で判定 | E-01 (976-980行目) | ○ |
| C-12 | updateCameraでnear/farを同期 | E-01 (1107-1108行目) | ○ |
| C-13 | setProjectionFromUnionでステレオ投影を計算 | E-01 (1153行目, 1204-1265行目) | ○ |
| C-14 | getControllerでWebXRController取得 | E-01 (406-412行目) | ○ |
| C-15 | getControllerGripでgrip空間取得 | E-01 (422-428行目) | ○ |
| C-16 | getHandでhand空間取得 | E-01 (438-444行目) | ○ |
| C-17 | createQuadLayerでQuadレイヤー作成 | E-01 (653-726行目) | ○ |
| C-18 | createCylinderLayerでCylinderレイヤー作成 | E-01 (744-818行目) | ○ |
| C-19 | renderLayersでXRレイヤーをレンダリング | E-01 (826-895行目) | ○ |
| C-20 | onAnimationFrameでviewerPose取得 | E-01 (1561行目) | ○ |
| C-21 | onAnimationFrameでコントローラー更新 | E-01 (1652-1663行目) | ○ |
| C-22 | sessionstartイベントを発火 | E-01 (1088行目) | ○ |
| C-23 | sessionendイベントを発火 | E-01 (1443行目) | ○ |
| C-24 | 機能一覧に「WebXRセッション管理」として登録 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主要機能が実装と一致
- 0: 低リスク - セッション管理フローの記述
- 0: 低リスク - カメラ更新ロジックの記述

## 6) レビュアーチェックリスト（最小）
- [ ] setSessionのXRProjectionLayer/XRWebGLLayer分岐を確認
- [ ] updateCameraのステレオ投影計算を確認
- [ ] onAnimationFrameのフレーム更新処理を確認
- [ ] createQuadLayer/createCylinderLayerのレイヤー作成処理を確認
