---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-Camera

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cameras/Camera.js` 1-161行目
- E-02: `src/core/Object3D.js`（継承元クラス）
- E-03: `src/math/Matrix4.js`（行列クラス）
- E-04: `src/constants.js`（WebGLCoordinateSystem定数）
- E-05: `機能一覧.csv` 18行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Object3Dクラスを継承している | E-01 (3行目, 18行目) | ○ |
| C-02 | isCameraフラグがtrueに設定される | E-01 (34行目) | ○ |
| C-03 | type = 'Camera'が設定される | E-01 (36行目) | ○ |
| C-04 | matrixWorldInverseがMatrix4で初期化される | E-01 (43行目) | ○ |
| C-05 | projectionMatrixがMatrix4で初期化される | E-01 (50行目) | ○ |
| C-06 | projectionMatrixInverseがMatrix4で初期化される | E-01 (57行目) | ○ |
| C-07 | coordinateSystemのデフォルトはWebGLCoordinateSystem | E-01 (1行目, 64行目) | ○ |
| C-08 | _reversedDepthのデフォルトはfalse | E-01 (66行目) | ○ |
| C-09 | reversedDepthゲッターが存在する | E-01 (76-80行目) | ○ |
| C-10 | copy()メソッドで行列と座標系をコピー | E-01 (82-95行目) | ○ |
| C-11 | getWorldDirection()は負のZ方向を返す | E-01 (106-110行目) | ○ |
| C-12 | getWorldDirection()はObject3Dの結果をnegate | E-01 (108行目) | ○ |
| C-13 | updateMatrixWorld()でsuper呼び出し後にmatrixWorldInverseを計算 | E-01 (112-130行目) | ○ |
| C-14 | スケール=(1,1,1)時は直接invert | E-01 (120-122行目) | ○ |
| C-15 | スケール!=(1,1,1)時はスケールを除外してinvert | E-01 (124-128行目) | ○ |
| C-16 | updateWorldMatrix()でも同様のmatrixWorldInverse計算 | E-01 (132-150行目) | ○ |
| C-17 | clone()で新インスタンスを作成可能 | E-01 (152-156行目) | ○ |
| C-18 | glTF準拠のためスケールを除外するコメントあり | E-01 (116-117行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] CameraとObject3Dの継承関係が正しく記述されているか確認
- [ ] matrixWorldInverseの計算ロジックが正しく説明されているか確認
- [ ] getWorldDirectionの動作が正しく記述されているか確認
- [ ] スケール除外の理由（glTF準拠）が適切に説明されているか確認
