---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-PerspectiveCamera

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cameras/PerspectiveCamera.js` 1-408行目
- E-02: `src/cameras/Camera.js`（継承元クラス）
- E-03: `src/math/MathUtils.js`（DEG2RAD, RAD2DEG）
- E-04: `src/math/Matrix4.js`（makePerspective）
- E-05: `機能一覧.csv` 19行目
- E-06: `画面機能マッピング.csv` 複数行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Cameraクラスを継承している | E-01 (1行目, 23行目) | ○ |
| C-02 | isPerspectiveCameraフラグがtrueに設定される | E-01 (44行目) | ○ |
| C-03 | type = 'PerspectiveCamera'が設定される | E-01 (46行目) | ○ |
| C-04 | fovのデフォルトは50 | E-01 (33行目, 55行目) | ○ |
| C-05 | zoomのデフォルトは1 | E-01 (63行目) | ○ |
| C-06 | nearのデフォルトは0.1 | E-01 (33行目, 75行目) | ○ |
| C-07 | farのデフォルトは2000 | E-01 (33行目, 84行目) | ○ |
| C-08 | focusのデフォルトは10 | E-01 (94行目) | ○ |
| C-09 | aspectのデフォルトは1 | E-01 (33行目, 102行目) | ○ |
| C-10 | viewのデフォルトはnull | E-01 (111行目) | ○ |
| C-11 | filmGaugeのデフォルトは35 | E-01 (121行目) | ○ |
| C-12 | filmOffsetのデフォルトは0 | E-01 (129行目) | ○ |
| C-13 | コンストラクタ最後にupdateProjectionMatrix()呼び出し | E-01 (131行目) | ○ |
| C-14 | setFocalLength()で焦点距離からFOVを計算 | E-01 (164-172行目) | ○ |
| C-15 | getFocalLength()でFOVから焦点距離を計算 | E-01 (180-186行目) | ○ |
| C-16 | getEffectiveFOV()でズーム考慮のFOVを取得 | E-01 (193-198行目) | ○ |
| C-17 | getFilmWidth/Height()でフィルムサイズを取得 | E-01 (206-224行目) | ○ |
| C-18 | getViewBounds()でビュー境界を取得 | E-01 (234-244行目) | ○ |
| C-19 | setViewOffset()でマルチモニター対応 | E-01 (304-332行目) | ○ |
| C-20 | clearViewOffset()でビューオフセットを解除 | E-01 (337-347行目) | ○ |
| C-21 | updateProjectionMatrix()でprojectionMatrix計算 | E-01 (353-381行目) | ○ |
| C-22 | 複数の画面で使用される | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PerspectiveCameraとCameraの継承関係が正しく記述されているか確認
- [ ] updateProjectionMatrix()の計算ロジックが正しく説明されているか確認
- [ ] setFocalLength/getFocalLengthの動作が正しく記述されているか確認
- [ ] 画面機能マッピングとの整合性確認
