---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-OrthographicCamera

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cameras/OrthographicCamera.js` 1-246行目
- E-02: `src/cameras/Camera.js`（継承元クラス）
- E-03: `src/math/Matrix4.js`（makeOrthographic, makeOrthographicReversed）
- E-04: `機能一覧.csv` 20行目
- E-05: `画面機能マッピング.csv` 複数行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Cameraクラスを継承している | E-01 (1行目, 14行目) | ○ |
| C-02 | isOrthographicCameraフラグがtrueに設定される | E-01 (30行目) | ○ |
| C-03 | type = 'OrthographicCamera'が設定される | E-01 (32行目) | ○ |
| C-04 | zoomのデフォルトは1 | E-01 (39行目) | ○ |
| C-05 | viewのデフォルトはnull | E-01 (47行目) | ○ |
| C-06 | leftのデフォルトは-1 | E-01 (21行目, 56行目) | ○ |
| C-07 | rightのデフォルトは1 | E-01 (21行目, 64行目) | ○ |
| C-08 | topのデフォルトは1 | E-01 (21行目, 72行目) | ○ |
| C-09 | bottomのデフォルトは-1 | E-01 (21行目, 80行目) | ○ |
| C-10 | nearのデフォルトは0.1 | E-01 (21行目, 88行目) | ○ |
| C-11 | farのデフォルトは2000 | E-01 (21行目, 96行目) | ○ |
| C-12 | コンストラクタ最後にupdateProjectionMatrix()呼び出し | E-01 (98行目) | ○ |
| C-13 | setViewOffset()でマルチモニター対応 | E-01 (129-155行目) | ○ |
| C-14 | clearViewOffset()でビューオフセットを解除 | E-01 (160-170行目) | ○ |
| C-15 | updateProjectionMatrix()でdx, dy, cx, cyを計算 | E-01 (178-181行目) | ○ |
| C-16 | zoom値で境界をスケーリング | E-01 (178-179行目) | ○ |
| C-17 | view.enabled時にオフセット適用 | E-01 (190-201行目) | ○ |
| C-18 | reversedDepth時はmakeOrthographicReversedを使用 | E-01 (203-209行目) | ○ |
| C-19 | projectionMatrixInverse.invert()で逆行列を計算 | E-01 (211行目) | ○ |
| C-20 | copy()とtoJSON()メソッドを持つ | E-01 (219-246行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] OrthographicCameraとCameraの継承関係が正しく記述されているか確認
- [ ] updateProjectionMatrix()の計算ロジック（dx, dy, cx, cy）が正しく説明されているか確認
- [ ] reversedDepthの分岐処理が正しく記述されているか確認
- [ ] setViewOffset/clearViewOffsetの動作が正しく記述されているか確認
- [ ] 画面機能マッピングとの整合性確認
