---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-CubeCamera

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cameras/CubeCamera.js` 1-249行目
- E-02: `src/cameras/PerspectiveCamera.js` 1-407行目
- E-03: `src/core/Object3D.js` 1-100行目
- E-04: `src/constants.js` WebGLCoordinateSystem, WebGPUCoordinateSystem定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` No.21行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CubeCameraはObject3Dを継承している | E-01: 38行目 `class CubeCamera extends Object3D` | ○ |
| C-02 | 6つのPerspectiveCameraを内部に生成する | E-01: 76-98行目 | ○ |
| C-03 | FOVは-90度に固定 | E-01: 5行目 `const fov = - 90` | ○ |
| C-04 | アスペクト比は1:1 | E-01: 6行目 `const aspect = 1` | ○ |
| C-05 | near/far/renderTargetをコンストラクタで受け取る | E-01: 47行目 `constructor( near, far, renderTarget )` | ○ |
| C-06 | coordinateSystemプロパティを持つ | E-01: 66行目 | ○ |
| C-07 | activeMipmapLevelプロパティを持つ | E-01: 74行目 | ○ |
| C-08 | updateCoordinateSystem()で座標系に応じたカメラ向きを設定 | E-01: 105-169行目 | ○ |
| C-09 | WebGL座標系のカメラ向き設定 | E-01: 115-133行目 | ○ |
| C-10 | WebGPU座標系のカメラ向き設定 | E-01: 135-153行目 | ○ |
| C-11 | 無効な座標系でErrorをスロー | E-01: 157行目 | ○ |
| C-12 | update()でシーンを6面レンダリング | E-01: 178-244行目 | ○ |
| C-13 | XRを一時的に無効化 | E-01: 200行目 `renderer.xr.enabled = false` | ○ |
| C-14 | ミップマップ生成を一時的に無効化 | E-01: 204行目 `renderTarget.texture.generateMipmaps = false` | ○ |
| C-15 | reversedDepthBufferに対応 | E-01: 207行目 | ○ |
| C-16 | 6面それぞれでrender()を呼び出し | E-01: 209-236行目 | ○ |
| C-17 | needsPMREMUpdateフラグを設定 | E-01: 242行目 | ○ |
| C-18 | 機能一覧での説明と一致 | E-05: No.21「環境マッピング用の6面キューブカメラ」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 全ての主張がソースコードに基づいている
- [x] 機能一覧の説明と整合性がある
- [x] コードリーディングガイドの行番号が正確である
- [ ] 実際の使用例（サンプルコード）との整合性確認
