---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-StereoCamera

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cameras/StereoCamera.js` 1-147行目
- E-02: `src/cameras/PerspectiveCamera.js` 1-407行目
- E-03: `src/math/Matrix4.js` Matrix4クラス
- E-04: `src/math/MathUtils.js` DEG2RAD定数
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` No.22行
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.26関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StereoCameraは2つのPerspectiveCameraを管理する | E-01: 54行目, 64行目 | ○ |
| C-02 | type = 'StereoCamera' | E-01: 29行目 | ○ |
| C-03 | デフォルトのaspectは1 | E-01: 37行目 | ○ |
| C-04 | デフォルトのeyeSepは0.064 | E-01: 46行目 | ○ |
| C-05 | cameraLはレイヤー1に設定 | E-01: 55行目 `this.cameraL.layers.enable( 1 )` | ○ |
| C-06 | cameraRはレイヤー2に設定 | E-01: 65行目 `this.cameraR.layers.enable( 2 )` | ○ |
| C-07 | matrixAutoUpdateはfalseに設定 | E-01: 56行目, 66行目 | ○ |
| C-08 | キャッシュオブジェクトを持つ | E-01: 68-76行目 | ○ |
| C-09 | update()でパラメータ変更時のみ再計算 | E-01: 89-91行目 | ○ |
| C-10 | Paul Bourkeのアルゴリズムを使用 | E-01: 103-104行目コメント | ○ |
| C-11 | eyeSepHalfを計算 | E-01: 107行目 | ○ |
| C-12 | eyeSepOnProjectionを計算 | E-01: 108行目 | ○ |
| C-13 | 左目用投影行列の計算 | E-01: 119-124行目 | ○ |
| C-14 | 右目用投影行列の計算 | E-01: 129-135行目 | ○ |
| C-15 | ワールド行列の計算 | E-01: 139-140行目 | ○ |
| C-16 | 機能一覧での説明と一致 | E-05: No.22「VR/ステレオ表示用の左右分離カメラ」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 全ての主張がソースコードに基づいている
- [x] 機能一覧の説明と整合性がある
- [x] 画面機能マッピングとの整合性がある
- [x] コードリーディングガイドの行番号が正確である
- [ ] Paul Bourkeのアルゴリズム（参照URL）の確認
