---
generated_at: 2026-01-27 10:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-TorusGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/geometries/TorusGeometry.js` - TorusGeometryクラス定義
- E-02: `src/core/BufferGeometry.js` - 基底クラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TorusGeometryはBufferGeometryを継承 | E-01 (18行目: `class TorusGeometry extends BufferGeometry`) | ○ |
| C-02 | radiusのデフォルト値は1 | E-01 (31行目: `radius = 1`) | ○ |
| C-03 | tubeのデフォルト値は0.4 | E-01 (31行目: `tube = 0.4`) | ○ |
| C-04 | radialSegmentsのデフォルト値は12 | E-01 (31行目: `radialSegments = 12`) | ○ |
| C-05 | tubularSegmentsのデフォルト値は48 | E-01 (31行目: `tubularSegments = 48`) | ○ |
| C-06 | arcのデフォルト値はMath.PI*2 | E-01 (31行目: `arc = Math.PI * 2`) | ○ |
| C-07 | thetaStartのデフォルト値は0 | E-01 (31行目: `thetaStart = 0`) | ○ |
| C-08 | thetaLengthのデフォルト値はMath.PI*2 | E-01 (31行目: `thetaLength = Math.PI * 2`) | ○ |
| C-09 | 頂点座標計算式 x = (radius + tube*cos(v))*cos(u) | E-01 (82行目) | ○ |
| C-10 | 頂点座標計算式 y = (radius + tube*cos(v))*sin(u) | E-01 (83行目) | ○ |
| C-11 | 頂点座標計算式 z = tube*sin(v) | E-01 (84行目) | ○ |
| C-12 | 法線は頂点-中心を正規化 | E-01 (92行目: `normal.subVectors( vertex, center ).normalize()`) | ○ |
| C-13 | Geometry Browserで使用される | E-04 (113行目: 画面35でTorusGeometry) | ○ |
| C-14 | Sidebar - Geometryで編集可能 | E-04 (31行目: 画面5でTorusGeometry) | ○ |
| C-15 | Menubar - Addで追加可能 | E-04 (56行目: 画面12でTorusGeometry) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パラメトリック方程式が正しく記載されているか確認
- [ ] デフォルトパラメータがソースコードと一致するか確認
- [ ] 関連画面との対応が正しいか確認
