---
generated_at: 2026-01-27 10:34:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-TorusKnotGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/geometries/TorusKnotGeometry.js` - TorusKnotGeometryクラス定義
- E-02: `src/core/BufferGeometry.js` - 基底クラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TorusKnotGeometryはBufferGeometryを継承 | E-01 (20行目: `class TorusKnotGeometry extends BufferGeometry`) | ○ |
| C-02 | radiusのデフォルト値は1 | E-01 (32行目: `radius = 1`) | ○ |
| C-03 | tubeのデフォルト値は0.4 | E-01 (32行目: `tube = 0.4`) | ○ |
| C-04 | tubularSegmentsのデフォルト値は64 | E-01 (32行目: `tubularSegments = 64`) | ○ |
| C-05 | radialSegmentsのデフォルト値は8 | E-01 (32行目: `radialSegments = 8`) | ○ |
| C-06 | pのデフォルト値は2 | E-01 (32行目: `p = 2`) | ○ |
| C-07 | qのデフォルト値は3 | E-01 (32行目: `q = 3`) | ○ |
| C-08 | calculatePositionOnCurve関数が存在 | E-01 (166-177行目) | ○ |
| C-09 | x座標計算: radius*(2+cs)*0.5*cu | E-01 (173行目) | ○ |
| C-10 | y座標計算: radius*(2+cs)*su*0.5 | E-01 (174行目) | ○ |
| C-11 | z座標計算: radius*sin(quOverP)*0.5 | E-01 (175行目) | ○ |
| C-12 | Frenet-SerretフレームでT, N, Bを計算 | E-01 (92-100行目) | ○ |
| C-13 | 法線は vertex - P1 を正規化 | E-01 (122行目: `normal.subVectors( vertex, P1 ).normalize()`) | ○ |
| C-14 | Menubar - Addで追加可能 | E-04 (57行目: 画面12でTorusKnotGeometry) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] トーラスノット曲線のパラメトリック方程式が正しく記載されているか確認
- [ ] Frenet-Serretフレームの計算が数学的に正しいか確認
- [ ] pとqのデフォルト値（2, 3）で三葉結び目が生成されることを確認
