---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-CapsuleGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/geometries/CapsuleGeometry.js` - CapsuleGeometryクラス定義
- E-02: `src/core/BufferGeometry.js` - 基底クラス定義
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CapsuleGeometryはBufferGeometryを継承 | E-01 (18行目: `class CapsuleGeometry extends BufferGeometry`) | ○ |
| C-02 | radiusのデフォルト値は1 | E-01 (29行目: `radius = 1`) | ○ |
| C-03 | heightのデフォルト値は1 | E-01 (29行目: `height = 1`) | ○ |
| C-04 | capSegmentsのデフォルト値は4 | E-01 (29行目: `capSegments = 4`) | ○ |
| C-05 | radialSegmentsのデフォルト値は8 | E-01 (29行目: `radialSegments = 8`) | ○ |
| C-06 | heightSegmentsのデフォルト値は1 | E-01 (29行目: `heightSegments = 1`) | ○ |
| C-07 | heightは0以上を保証 | E-01 (50行目: `height = Math.max( 0, height )`) | ○ |
| C-08 | capSegmentsは1以上を保証 | E-01 (51行目: `capSegments = Math.max( 1, Math.floor( capSegments ) )`) | ○ |
| C-09 | radialSegmentsは3以上を保証 | E-01 (52行目: `radialSegments = Math.max( 3, Math.floor( radialSegments ) )`) | ○ |
| C-10 | heightSegmentsは1以上を保証 | E-01 (53行目: `heightSegments = Math.max( 1, Math.floor( heightSegments ) )`) | ○ |
| C-11 | capArcLengthの計算式 | E-01 (65行目: `const capArcLength = ( Math.PI / 2 ) * radius`) | ○ |
| C-12 | 3領域で処理を分岐 | E-01 (84-114行目: if/else if/else構造) | ○ |
| C-13 | 法線を正規化 | E-01 (156行目: `normal.normalize()`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータの検証ロジックがソースコードと一致するか確認
- [ ] 3領域（下部キャップ、中央円柱、上部キャップ）の境界条件を確認
- [ ] UV座標の連続性が正しく実装されているか確認
