---
generated_at: 2026-01-27 10:44:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-ExtrudeGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/geometries/ExtrudeGeometry.js` - ExtrudeGeometryクラス定義
- E-02: `src/extras/ShapeUtils.js` - ShapeUtils定義
- E-03: `src/core/BufferGeometry.js` - 基底クラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExtrudeGeometryはBufferGeometryを継承 | E-01 (32行目: `class ExtrudeGeometry extends BufferGeometry`) | ○ |
| C-02 | curveSegmentsのデフォルト値は12 | E-01 (87行目: `curveSegments !== undefined ? options.curveSegments : 12`) | ○ |
| C-03 | stepsのデフォルト値は1 | E-01 (88行目: `steps !== undefined ? options.steps : 1`) | ○ |
| C-04 | depthのデフォルト値は1 | E-01 (89行目: `depth !== undefined ? options.depth : 1`) | ○ |
| C-05 | bevelEnabledのデフォルト値はtrue | E-01 (91行目: `bevelEnabled !== undefined ? options.bevelEnabled : true`) | ○ |
| C-06 | bevelThicknessのデフォルト値は0.2 | E-01 (92行目: `bevelThickness !== undefined ? options.bevelThickness : 0.2`) | ○ |
| C-07 | bevelSegmentsのデフォルト値は3 | E-01 (95行目: `bevelSegments !== undefined ? options.bevelSegments : 3`) | ○ |
| C-08 | extrudePath使用時はbevelがfalseに | E-01 (111行目: `bevelEnabled = false`) | ○ |
| C-09 | extractPointsでshapeとholesを取得 | E-01 (140行目: `shape.extractPoints( curveSegments )`) | ○ |
| C-10 | ShapeUtils.isClockWiseで巻き方向確認 | E-01 (145行目, E-02) | ○ |
| C-11 | ShapeUtils.triangulateShapeで三角形分割 | E-01 (402行目: `ShapeUtils.triangulateShape`) | ○ |
| C-12 | buildLidFaces関数が存在 | E-01 (574行目: `function buildLidFaces()`) | ○ |
| C-13 | buildSideFaces関数が存在 | E-01 (632行目: `function buildSideFaces()`) | ○ |
| C-14 | computeVertexNormalsを呼び出し | E-01 (77行目: `this.computeVertexNormals()`) | ○ |
| C-15 | WorldUVGeneratorがデフォルト | E-01 (99行目, 808行目) | ○ |
| C-16 | mergeOverlappingPointsで重複点除去 | E-01 (170-202行目, 204-205行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] オプションのデフォルト値がソースコードと一致するか確認
- [ ] extrudePath使用時のベベル無効化が正しく記載されているか確認
- [ ] 三角形分割（Earcut）の呼び出し箇所を確認
- [ ] マテリアルグループ（蓋と側面）の分離を確認
