---
generated_at: 2026-01-27 10:46:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-ShapeGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/geometries/ShapeGeometry.js` - ShapeGeometryクラス定義
- E-02: `src/extras/ShapeUtils.js` - ShapeUtils定義
- E-03: `src/core/BufferGeometry.js` - 基底クラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShapeGeometryはBufferGeometryを継承 | E-01 (24行目: `class ShapeGeometry extends BufferGeometry`) | ○ |
| C-02 | curveSegmentsのデフォルト値は12 | E-01 (32行目: `curveSegments = 12`) | ○ |
| C-03 | デフォルトシェイプは三角形 | E-01 (32行目: `new Shape( [ new Vector2( 0, 0.5 ), ... ] )`) | ○ |
| C-04 | extractPointsで輪郭と穴を抽出 | E-01 (96行目: `shape.extractPoints( curveSegments )`) | ○ |
| C-05 | isClockWiseで巻き方向確認 | E-01 (103行目: `ShapeUtils.isClockWise( shapeVertices )`) | ○ |
| C-06 | 反時計回りでなければreverse | E-01 (105行目: `shapeVertices = shapeVertices.reverse()`) | ○ |
| C-07 | 穴は時計回りでなければreverse | E-01 (113-115行目) | ○ |
| C-08 | triangulateShapeで三角形分割 | E-01 (121行目: `ShapeUtils.triangulateShape( shapeVertices, shapeHoles )`) | ○ |
| C-09 | 頂点のz座標は0 | E-01 (138行目: `vertices.push( vertex.x, vertex.y, 0 )`) | ○ |
| C-10 | 法線は(0,0,1) | E-01 (139行目: `normals.push( 0, 0, 1 )`) | ○ |
| C-11 | UV座標はワールド座標 | E-01 (140行目: `uvs.push( vertex.x, vertex.y )`) | ○ |
| C-12 | 複数シェイプ時にaddGroup | E-01 (74行目: `this.addGroup( groupStart, groupCount, i )`) | ○ |
| C-13 | toJSON/fromJSONが存在 | E-01 (173-205行目, 183-205行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 巻き方向の処理（輪郭は反時計回り、穴は時計回り）が正しく記載されているか確認
- [ ] 頂点のz座標が0であることを確認
- [ ] UV座標がワールド座標（vertex.x, vertex.y）であることを確認
- [ ] 複数シェイプ時のマテリアルグループ設定を確認
