---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Raycaster.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/Raycaster.js` - Raycasterクラスのソースコード
- E-02: `src/math/Ray.js` - Rayクラスのソースコード
- E-03: `src/core/Layers.js` - Layersクラスのソースコード
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Raycasterは内部でRayインスタンスを持つ | E-01 (30行目: `this.ray = new Ray( origin, direction )`) | ○ |
| C-02 | nearのデフォルトは0 | E-01 (23行目: `near = 0`) | ○ |
| C-03 | farのデフォルトはInfinity | E-01 (23行目: `far = Infinity`) | ○ |
| C-04 | cameraのデフォルトはnull | E-01 (56行目: `this.camera = null`) | ○ |
| C-05 | layersはLayersインスタンス | E-01 (69行目: `this.layers = new Layers()`) | ○ |
| C-06 | paramsにMesh, Line, LOD, Points, Spriteの設定がある | E-01 (88-94行目) | ○ |
| C-07 | Line.thresholdのデフォルトは1 | E-01 (90行目: `Line: { threshold: 1 }`) | ○ |
| C-08 | Points.thresholdのデフォルトは1 | E-01 (92行目: `Points: { threshold: 1 }`) | ○ |
| C-09 | set()でray.set()が呼ばれる | E-01 (108行目: `this.ray.set( origin, direction )`) | ○ |
| C-10 | setFromCamera()でPerspectiveCameraの場合、originはカメラ位置 | E-01 (123行目: `this.ray.origin.setFromMatrixPosition( camera.matrixWorld )`) | ○ |
| C-11 | setFromCamera()でOrthographicCameraの場合、directionは(0,0,-1) | E-01 (130行目: `this.ray.direction.set( 0, 0, - 1 )`) | ○ |
| C-12 | 非対応カメラタイプでエラー出力 | E-01 (135行目: `error( 'Raycaster: Unsupported camera type: ' + camera.type )`) | ○ |
| C-13 | setFromXRController()でcontroller.matrixWorldから位置・方向取得 | E-01 (149-152行目) | ○ |
| C-14 | intersectObject()で結果を距離順にソート | E-01 (198行目: `intersects.sort( ascSort )`) | ○ |
| C-15 | ascSort()はa.distance - b.distanceで比較 | E-01 (230-234行目: `return a.distance - b.distance`) | ○ |
| C-16 | intersect()でlayers.test()によるフィルタリング | E-01 (240行目: `if ( object.layers.test( raycaster.layers ) )`) | ○ |
| C-17 | object.raycast()がfalseを返すと子の判定をスキップ | E-01 (244行目: `if ( result === false ) propagate = false`) | ○ |
| C-18 | 関連画面として1画面（Viewport）が該当 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PerspectiveCameraとOrthographicCameraのレイ設定ロジックが正確か確認
- [ ] setFromXRController()のmatrix計算が正確か確認
- [ ] layers.test()のフィルタリング動作を確認
- [ ] 関連画面の一覧が画面機能マッピングと一致しているか確認
