---
generated_at: 2026-01-27 10:48:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-TubeGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/geometries/TubeGeometry.js` - TubeGeometryクラス定義
- E-02: `src/extras/core/Curve.js` - Curveクラス定義
- E-03: `src/core/BufferGeometry.js` - 基底クラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TubeGeometryはBufferGeometryを継承 | E-01 (34行目: `class TubeGeometry extends BufferGeometry`) | ○ |
| C-02 | pathのデフォルトはQuadraticBezierCurve3 | E-01 (45行目) | ○ |
| C-03 | tubularSegmentsのデフォルト値は64 | E-01 (45行目: `tubularSegments = 64`) | ○ |
| C-04 | radiusのデフォルト値は1 | E-01 (45行目: `radius = 1`) | ○ |
| C-05 | radialSegmentsのデフォルト値は8 | E-01 (45行目: `radialSegments = 8`) | ○ |
| C-06 | closedのデフォルト値はfalse | E-01 (45行目: `closed = false`) | ○ |
| C-07 | computeFrenetFramesを呼び出し | E-01 (66行目: `path.computeFrenetFrames( tubularSegments, closed )`) | ○ |
| C-08 | tangents, normals, binormalsを保存 | E-01 (70-72行目) | ○ |
| C-09 | getPointAtで曲線上の点を取得 | E-01 (131行目: `P = path.getPointAt( i / tubularSegments, P )`) | ○ |
| C-10 | 法線計算: cos×N + sin×B | E-01 (149-151行目) | ○ |
| C-11 | 頂点計算: P + radius×normal | E-01 (158-160行目) | ○ |
| C-12 | UV座標: u = i/tubularSegments, v = j/radialSegments | E-01 (196-197行目) | ○ |
| C-13 | closed=trueで最初と最後を接続 | E-01 (114行目: `( closed === false ) ? tubularSegments : 0`) | ○ |
| C-14 | generateBufferData関数が存在 | E-01 (101行目: `function generateBufferData()`) | ○ |
| C-15 | generateSegment関数が存在 | E-01 (127行目: `function generateSegment( i )`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Frenet-Serretフレームの計算がソースコードと一致するか確認
- [ ] 法線と頂点の計算式が正しく記載されているか確認
- [ ] closed=trueの場合の処理が正しいか確認
- [ ] UV座標の計算が正しいか確認
