---
generated_at: 2026-01-27 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-PolyhedronGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/geometries/PolyhedronGeometry.js` 1-349行目
- E-02: `src/core/BufferGeometry.js`（基底クラス）
- E-03: `src/core/BufferAttribute.js`（Float32BufferAttribute）
- E-04: `src/math/Vector3.js`（ベクトル演算）
- E-05: `src/math/Vector2.js`（UV計算用）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 41行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PolyhedronGeometryはBufferGeometryを継承する | E-01: 13行目 `class PolyhedronGeometry extends BufferGeometry` | ○ |
| C-02 | vertices, indices, radius, detailの4パラメータを受け取る | E-01: 23行目 `constructor( vertices = [], indices = [], radius = 1, detail = 0 )` | ○ |
| C-03 | パラメータのデフォルト値（vertices=[], indices=[], radius=1, detail=0） | E-01: 23行目 | ○ |
| C-04 | parametersプロパティにコンストラクタ引数を保存 | E-01: 36-41行目 | ○ |
| C-05 | subdivide関数で三角形面を細分化 | E-01: 50行目、78-100行目 | ○ |
| C-06 | subdivideFace関数で単一三角形を細分化 | E-01: 102-163行目 | ○ |
| C-07 | applyRadius関数で球面投影と半径適用 | E-01: 54行目、165-185行目 | ○ |
| C-08 | generateUVs関数でUV座標を生成 | E-01: 58行目、187-207行目 | ○ |
| C-09 | azimuth関数で方位角を計算（atan2使用） | E-01: 306-308行目 `Math.atan2( vector.z, - vector.x )` | ○ |
| C-10 | inclination関数で仰角を計算 | E-01: 315-318行目 | ○ |
| C-11 | correctSeam関数でテクスチャ継ぎ目を補正 | E-01: 209-236行目 | ○ |
| C-12 | position属性をFloat32BufferAttributeで設定 | E-01: 62行目 | ○ |
| C-13 | normal属性をFloat32BufferAttributeで設定 | E-01: 63行目 | ○ |
| C-14 | uv属性をFloat32BufferAttributeで設定 | E-01: 64行目 | ○ |
| C-15 | detail=0の場合はcomputeVertexNormalsでフラット法線 | E-01: 66-68行目 | ○ |
| C-16 | detail>0の場合はnormalizeNormalsでスムーズ法線 | E-01: 70-74行目 | ○ |
| C-17 | copyメソッドでparametersもコピー | E-01: 323-331行目 | ○ |
| C-18 | fromJSONスタティックメソッドでJSON復元 | E-01: 340-344行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 細分化アルゴリズム（subdivideFace）の数学的正確性を確認
- [ ] UV座標計算の球面マッピング式が正しいことを確認
- [ ] シーム補正ロジック（0.9/0.1閾値）の妥当性を確認
