---
generated_at: 2026-01-27 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-EdgesGeometry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/geometries/EdgesGeometry.js` 1-181行目
- E-02: `src/core/BufferGeometry.js`（基底クラス）
- E-03: `src/math/Triangle.js`（法線計算）
- E-04: `src/math/MathUtils.js`（DEG2RAD定数）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 46行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EdgesGeometryはBufferGeometryを継承する | E-01: 26行目 `class EdgesGeometry extends BufferGeometry` | ○ |
| C-02 | geometry, thresholdAngleの2パラメータを受け取る | E-01: 35行目 `constructor( geometry = null, thresholdAngle = 1 )` | ○ |
| C-03 | デフォルト値はgeometry=null, thresholdAngle=1 | E-01: 35行目 | ○ |
| C-04 | parametersプロパティに引数を保存 | E-01: 48-51行目 | ○ |
| C-05 | precisionPointsが4で精度が10^4 | E-01: 55-56行目 | ○ |
| C-06 | thresholdDotをcosで計算 | E-01: 57行目 `Math.cos( DEG2RAD * thresholdAngle )` | ○ |
| C-07 | 縮退三角形をスキップ | E-01: 97-101行目 ハッシュが同一の場合continue | ○ |
| C-08 | 逆ハッシュを用いてエッジを照合 | E-01: 113-114行目 hash, reverseHashの生成 | ○ |
| C-09 | 法線内積がthresholdDot以下の場合のみエッジ追加 | E-01: 120行目 `_normal.dot( edgeData[ reverseHash ].normal ) <= thresholdDot` | ○ |
| C-10 | 未マッチエッジ（境界エッジ）も追加 | E-01: 147-160行目 | ○ |
| C-11 | position属性のみを設定 | E-01: 162行目 `this.setAttribute( 'position', ... )` | ○ |
| C-12 | copyメソッドでparametersもコピー | E-01: 168-176行目 | ○ |
| C-13 | Triangle.getNormalで法線計算 | E-01: 89行目 `_triangle.getNormal( _normal )` | ○ |
| C-14 | 頂点ハッシュを丸め処理で生成 | E-01: 92-94行目 `Math.round( a.x * precision )` | ○ |
| C-15 | シリアライズ非対応 | E-01: 22行目コメント「Note: It is not yet possible to serialize/deserialize」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] thresholdAngle=1度のデフォルト値が適切か確認
- [ ] 精度（precisionPoints=4）が十分か確認
- [ ] 法線内積判定のロジックが正しいことを確認
