---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-Material

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/Material.js` 1-1018行目
- E-02: `src/core/EventDispatcher.js`（基底クラス）
- E-03: `src/math/Color.js`（カラー管理）
- E-04: `src/math/MathUtils.js`（generateUUID）
- E-05: `src/constants.js`（定数定義）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 48行目
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MaterialはEventDispatcherを継承する | E-01: 17行目 `class Material extends EventDispatcher` | ○ |
| C-02 | isMaterialフラグがtrue | E-01: 33行目 `this.isMaterial = true` | ○ |
| C-03 | _materialIdでid自動生成 | E-01: 7行目, 42行目 | ○ |
| C-04 | generateUUIDでuuid生成 | E-01: 50行目 `this.uuid = generateUUID()` | ○ |
| C-05 | typeプロパティが'Material' | E-01: 66行目 `this.type = 'Material'` | ○ |
| C-06 | デフォルトブレンディングがNormalBlending | E-01: 78行目 `this.blending = NormalBlending` | ○ |
| C-07 | デフォルトsideがFrontSide | E-01: 86行目 `this.side = FrontSide` | ○ |
| C-08 | デフォルト透過度が1 | E-01: 109行目 `this.opacity = 1` | ○ |
| C-09 | depthTest/depthWriteのデフォルトがtrue | E-01: 218行目, 229行目 | ○ |
| C-10 | stencilWriteのデフォルトがfalse | E-01: 297行目 `this.stencilWrite = false` | ○ |
| C-11 | clippingPlanesのデフォルトがnull | E-01: 309行目 `this.clippingPlanes = null` | ○ |
| C-12 | versionのデフォルトが0 | E-01: 473行目 `this.version = 0` | ○ |
| C-13 | needsUpdate設定でversionインクリメント | E-01: 1009-1013行目 | ○ |
| C-14 | alphaTest変更でversionインクリメント | E-01: 493-503行目 | ○ |
| C-15 | setValuesメソッドでプロパティ設定 | E-01: 555-595行目 | ○ |
| C-16 | setValuesでundefined値の警告 | E-01: 565行目 `warn( ... 'undefined' ... )` | ○ |
| C-17 | setValuesで存在しないプロパティの警告 | E-01: 574行目 `warn( ... 'is not a property' ... )` | ○ |
| C-18 | toJSONメソッドでシリアライズ | E-01: 604-882行目 | ○ |
| C-19 | disposeメソッドでdisposeイベント発行 | E-01: 989-997行目 `this.dispatchEvent( { type: 'dispose' } )` | ○ |
| C-20 | copyメソッドでプロパティコピー | E-01: 901-981行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] プロパティのデフォルト値が適切か確認
- [ ] setValuesの警告メッセージが適切か確認
- [ ] toJSONのシリアライズ形式がObjectLoaderと互換性があるか確認
