---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-MeshBasicMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshBasicMaterial.js` 1-251行目
- E-02: `src/materials/Material.js`（基底クラス）
- E-03: `src/math/Color.js`（カラー管理）
- E-04: `src/math/Euler.js`（環境マップ回転）
- E-05: `src/constants.js`（MultiplyOperation定数）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 49行目
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshBasicMaterialはMaterialを継承する | E-01: 14行目 `class MeshBasicMaterial extends Material` | ○ |
| C-02 | isMeshBasicMaterialフラグがtrue | E-01: 36行目 `this.isMeshBasicMaterial = true` | ○ |
| C-03 | typeが'MeshBasicMaterial' | E-01: 38行目 `this.type = 'MeshBasicMaterial'` | ○ |
| C-04 | colorのデフォルトが0xffffff | E-01: 46行目 `this.color = new Color( 0xffffff )` | ○ |
| C-05 | mapのデフォルトがnull | E-01: 56行目 `this.map = null` | ○ |
| C-06 | lightMapのデフォルトがnull | E-01: 64行目 `this.lightMap = null` | ○ |
| C-07 | lightMapIntensityのデフォルトが1.0 | E-01: 72行目 `this.lightMapIntensity = 1.0` | ○ |
| C-08 | aoMapのデフォルトがnull | E-01: 80行目 `this.aoMap = null` | ○ |
| C-09 | aoMapIntensityのデフォルトが1.0 | E-01: 91行目 `this.aoMapIntensity = 1.0` | ○ |
| C-10 | envMapのデフォルトがnull | E-01: 122行目 `this.envMap = null` | ○ |
| C-11 | envMapRotationがEulerインスタンス | E-01: 130行目 `this.envMapRotation = new Euler()` | ○ |
| C-12 | combineのデフォルトがMultiplyOperation | E-01: 141行目 `this.combine = MultiplyOperation` | ○ |
| C-13 | reflectivityのデフォルトが1 | E-01: 150行目 `this.reflectivity = 1` | ○ |
| C-14 | refractionRatioのデフォルトが0.98 | E-01: 161行目 `this.refractionRatio = 0.98` | ○ |
| C-15 | wireframeのデフォルトがfalse | E-01: 169行目 `this.wireframe = false` | ○ |
| C-16 | fogのデフォルトがtrue | E-01: 207行目 `this.fog = true` | ○ |
| C-17 | setValuesでパラメータ適用 | E-01: 209行目 `this.setValues( parameters )` | ○ |
| C-18 | copyメソッドでプロパティコピー | E-01: 213-246行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 環境マップ合成モードが正しく動作するか確認
- [ ] lightMap/aoMapが第2UVセットを要求することを確認
- [ ] wireframeモードが正しく描画されることを確認
