---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-MeshLambertMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshLambertMaterial.js` 1-403行目
- E-02: `src/materials/Material.js`（基底クラス）
- E-03: `src/math/Color.js`（カラー管理）
- E-04: `src/math/Vector2.js`（法線スケール）
- E-05: `src/math/Euler.js`（環境マップ回転）
- E-06: `src/constants.js`（TangentSpaceNormalMap等の定数）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 50行目
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshLambertMaterialはMaterialを継承する | E-01: 24行目 `class MeshLambertMaterial extends Material` | ○ |
| C-02 | isMeshLambertMaterialフラグがtrue | E-01: 46行目 `this.isMeshLambertMaterial = true` | ○ |
| C-03 | typeが'MeshLambertMaterial' | E-01: 48行目 `this.type = 'MeshLambertMaterial'` | ○ |
| C-04 | colorのデフォルトが0xffffff | E-01: 56行目 `this.color = new Color( 0xffffff )` | ○ |
| C-05 | mapのデフォルトがnull | E-01: 66行目 `this.map = null` | ○ |
| C-06 | lightMapのデフォルトがnull | E-01: 74行目 `this.lightMap = null` | ○ |
| C-07 | aoMapのデフォルトがnull | E-01: 90行目 `this.aoMap = null` | ○ |
| C-08 | emissiveのデフォルトが0x000000 | E-01: 110行目 `this.emissive = new Color( 0x000000 )` | ○ |
| C-09 | emissiveIntensityのデフォルトが1.0 | E-01: 118行目 `this.emissiveIntensity = 1.0` | ○ |
| C-10 | emissiveMapのデフォルトがnull | E-01: 128行目 `this.emissiveMap = null` | ○ |
| C-11 | bumpMapのデフォルトがnull | E-01: 139行目 `this.bumpMap = null` | ○ |
| C-12 | bumpScaleのデフォルトが1 | E-01: 147行目 `this.bumpScale = 1` | ○ |
| C-13 | normalMapのデフォルトがnull | E-01: 160行目 `this.normalMap = null` | ○ |
| C-14 | normalMapTypeのデフォルトがTangentSpaceNormalMap | E-01: 168行目 `this.normalMapType = TangentSpaceNormalMap` | ○ |
| C-15 | normalScaleのデフォルトが(1,1) | E-01: 176行目 `this.normalScale = new Vector2( 1, 1 )` | ○ |
| C-16 | displacementMapのデフォルトがnull | E-01: 189行目 `this.displacementMap = null` | ○ |
| C-17 | displacementScaleのデフォルトが1 | E-01: 199行目 `this.displacementScale = 1` | ○ |
| C-18 | displacementBiasのデフォルトが0 | E-01: 209行目 `this.displacementBias = 0` | ○ |
| C-19 | flatShadingのデフォルトがfalse | E-01: 333行目 `this.flatShading = false` | ○ |
| C-20 | fogのデフォルトがtrue | E-01: 341行目 `this.fog = true` | ○ |
| C-21 | setValuesでパラメータ適用 | E-01: 343行目 `this.setValues( parameters )` | ○ |
| C-22 | copyメソッドでプロパティコピー | E-01: 347-398行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] Lambertシェーディングが光源に正しく反応することを確認
- [ ] normalMapとbumpMapの優先順位が正しいことを確認
- [ ] emissiveが光源に影響されないことを確認
