---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：51-MeshPhongMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス比較**：MeshStandardMaterial/MeshPhysicalMaterialとの具体的な計算コスト比較データなし
  2. **Blinn-Phongシェーディング計算式**：シェーダーコード未確認
  3. **60fps維持目標**：パフォーマンス要件の出典なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshPhongMaterial.js` - 7-21行目（クラスドキュメント）
- E-02: `src/materials/MeshPhongMaterial.js` - 22行目（クラス定義）
- E-03: `src/materials/MeshPhongMaterial.js` - 33-362行目（コンストラクタ）
- E-04: `src/materials/MeshPhongMaterial.js` - 44行目（isMeshPhongMaterial）
- E-05: `src/materials/MeshPhongMaterial.js` - 46行目（type）
- E-06: `src/materials/MeshPhongMaterial.js` - 54行目（color初期化）
- E-07: `src/materials/MeshPhongMaterial.js` - 63行目（specular初期化）
- E-08: `src/materials/MeshPhongMaterial.js` - 71行目（shininess初期化）
- E-09: `src/materials/MeshPhongMaterial.js` - 81行目（map）
- E-10: `src/materials/MeshPhongMaterial.js` - 89-97行目（lightMap, lightMapIntensity）
- E-11: `src/materials/MeshPhongMaterial.js` - 106-116行目（aoMap, aoMapIntensity）
- E-12: `src/materials/MeshPhongMaterial.js` - 125-143行目（emissive関連）
- E-13: `src/materials/MeshPhongMaterial.js` - 154-191行目（bump, normal関連）
- E-14: `src/materials/MeshPhongMaterial.js` - 203-224行目（displacement関連）
- E-15: `src/materials/MeshPhongMaterial.js` - 234行目（specularMap）
- E-16: `src/materials/MeshPhongMaterial.js` - 249行目（alphaMap）
- E-17: `src/materials/MeshPhongMaterial.js` - 257-304行目（envMap関連）
- E-18: `src/materials/MeshPhongMaterial.js` - 312-342行目（wireframe関連）
- E-19: `src/materials/MeshPhongMaterial.js` - 350行目（flatShading）
- E-20: `src/materials/MeshPhongMaterial.js` - 358行目（fog）
- E-21: `src/materials/MeshPhongMaterial.js` - 360行目（setValues呼び出し）
- E-22: `src/materials/MeshPhongMaterial.js` - 364-417行目（copyメソッド）
- E-23: `src/materials/Material.js` - 17行目（Materialクラス定義）
- E-24: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 36-37行目（関連画面）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshPhongMaterialはMaterialを継承している | E-02, E-23 | ○ |
| C-02 | Blinn-Phongシェーディングモデルを使用 | E-01 | ○ |
| C-03 | MeshLambertMaterialより光沢表面をシミュレート可能 | E-01 | ○ |
| C-04 | MeshStandardMaterial/PhysicalMaterialより計算コストが低い | E-01 | ○ |
| C-05 | isMeshPhongMaterialフラグがtrueで設定される | E-04 | ○ |
| C-06 | typeは'MeshPhongMaterial'で設定される | E-05 | ○ |
| C-07 | colorのデフォルト値は0xffffff | E-06 | ○ |
| C-08 | specularのデフォルト値は0x111111 | E-07 | ○ |
| C-09 | shininessのデフォルト値は30 | E-08 | ○ |
| C-10 | lightMapとaoMapは第2UVセットが必要 | E-10, E-11 | ○ |
| C-11 | normalMapが設定されるとbumpMapは無視される | E-13 | ○ |
| C-12 | 環境マップの合成モードはcombineプロパティで制御 | E-17 | ○ |
| C-13 | reflectivityのデフォルト値は1 | E-17 | ○ |
| C-14 | refractionRatioのデフォルト値は0.98 | E-17 | ○ |
| C-15 | wireframeLinewidthはSVGRendererでのみ有効 | E-18 | ○ |
| C-16 | flatShadingのデフォルト値はfalse | E-19 | ○ |
| C-17 | fogのデフォルト値はtrue | E-20 | ○ |
| C-18 | setValuesでパラメータを適用 | E-21 | ○ |
| C-19 | copyメソッドで全プロパティをコピー可能 | E-22 | ○ |
| C-20 | per-fragmentシェーディングを使用 | E-01 | ○ |
| C-21 | Sidebar - Materialで設定可能 | E-24 | ○ |
| C-22 | Material Browserでプレビュー可能 | E-24 | ○ |
| C-23 | emissiveIntensityのデフォルト値は1 | E-12 | ○ |
| C-24 | displacementScaleのデフォルト値は1 | E-14 | ○ |
| C-25 | 60fps維持がパフォーマンス目標 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（60fps維持目標）の公式ドキュメントまたは設計書の根拠
  - 候補：Three.js公式ドキュメント / パフォーマンスガイドライン / プロジェクト要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な事実のみ記載
- 1: 中リスク - パフォーマンス比較に関する定量的データなし

## 6) レビュアーチェックリスト（最小）
- [ ] Blinn-Phongシェーディングの計算式がシェーダーコードと一致するか確認
- [ ] パフォーマンス要件の根拠を確認（必要に応じて削除または修正）
- [ ] Material Browserでの表示確認（画面機能マッピングとの整合性）
