---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：52-MeshStandardMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Disney BRDF計算式**：シェーダーコード未確認
  2. **GGXマイクロファセットBRDF**：実装詳細未確認
  3. **PMREMGenerator連携**：内部処理フロー未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshStandardMaterial.js` - 7-40行目（クラスドキュメント）
- E-02: `src/materials/MeshStandardMaterial.js` - 41行目（クラス定義）
- E-03: `src/materials/MeshStandardMaterial.js` - 52-365行目（コンストラクタ）
- E-04: `src/materials/MeshStandardMaterial.js` - 63行目（isMeshStandardMaterial）
- E-05: `src/materials/MeshStandardMaterial.js` - 65行目（type）
- E-06: `src/materials/MeshStandardMaterial.js` - 67行目（defines）
- E-07: `src/materials/MeshStandardMaterial.js` - 75行目（color初期化）
- E-08: `src/materials/MeshStandardMaterial.js` - 85行目（roughness初期化）
- E-09: `src/materials/MeshStandardMaterial.js` - 96行目（metalness初期化）
- E-10: `src/materials/MeshStandardMaterial.js` - 106行目（map）
- E-11: `src/materials/MeshStandardMaterial.js` - 114-122行目（lightMap関連）
- E-12: `src/materials/MeshStandardMaterial.js` - 131-141行目（aoMap関連）
- E-13: `src/materials/MeshStandardMaterial.js` - 150-168行目（emissive関連）
- E-14: `src/materials/MeshStandardMaterial.js` - 179-216行目（bump, normal関連）
- E-15: `src/materials/MeshStandardMaterial.js` - 228-249行目（displacement関連）
- E-16: `src/materials/MeshStandardMaterial.js` - 258行目（roughnessMap）
- E-17: `src/materials/MeshStandardMaterial.js` - 267行目（metalnessMap）
- E-18: `src/materials/MeshStandardMaterial.js` - 282行目（alphaMap）
- E-19: `src/materials/MeshStandardMaterial.js` - 291-307行目（envMap関連）
- E-20: `src/materials/MeshStandardMaterial.js` - 315-345行目（wireframe関連）
- E-21: `src/materials/MeshStandardMaterial.js` - 353行目（flatShading）
- E-22: `src/materials/MeshStandardMaterial.js` - 361行目（fog）
- E-23: `src/materials/MeshStandardMaterial.js` - 363行目（setValues呼び出し）
- E-24: `src/materials/MeshStandardMaterial.js` - 367-421行目（copyメソッド）
- E-25: `src/materials/Material.js` - 17行目（Materialクラス定義）
- E-26: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 37-38行目（関連画面）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshStandardMaterialはMaterialを継承している | E-02, E-25 | ○ |
| C-02 | 物理ベースレンダリング（PBR）を使用 | E-01 | ○ |
| C-03 | Metallic-Roughnessワークフローを採用 | E-01 | ○ |
| C-04 | isMeshStandardMaterialフラグがtrueで設定される | E-04 | ○ |
| C-05 | typeは'MeshStandardMaterial'で設定される | E-05 | ○ |
| C-06 | definesに{ 'STANDARD': '' }が設定される | E-06 | ○ |
| C-07 | colorのデフォルト値は0xffffff | E-07 | ○ |
| C-08 | roughnessのデフォルト値は1.0 | E-08 | ○ |
| C-09 | metalnessのデフォルト値は0.0 | E-09 | ○ |
| C-10 | roughnessMapは緑チャンネルを使用 | E-16 | ○ |
| C-11 | metalnessMapは青チャンネルを使用 | E-17 | ○ |
| C-12 | lightMapとaoMapは第2UVセットが必要 | E-11, E-12 | ○ |
| C-13 | normalMapが設定されるとbumpMapは無視される | E-14 | ○ |
| C-14 | 環境マップはPMREMGeneratorで前処理される | E-19 | ○ |
| C-15 | envMapIntensityのデフォルト値は1.0 | E-19 | ○ |
| C-16 | wireframeLinewidthはSVGRendererでのみ有効 | E-20 | ○ |
| C-17 | flatShadingのデフォルト値はfalse | E-21 | ○ |
| C-18 | fogのデフォルト値はtrue | E-22 | ○ |
| C-19 | setValuesでパラメータを適用 | E-23 | ○ |
| C-20 | copyメソッドで全プロパティをコピー可能 | E-24 | ○ |
| C-21 | copyメソッドでdefinesを再設定する | E-24 | ○ |
| C-22 | per-fragmentシェーディングを使用 | E-01 | ○ |
| C-23 | MeshLambertMaterial/PhongMaterialより計算コストが高い | E-01 | ○ |
| C-24 | Sidebar - Materialで設定可能 | E-26 | ○ |
| C-25 | Material Browserでプレビュー可能 | E-26 | ○ |
| C-26 | emissiveIntensityのデフォルト値は1 | E-13 | ○ |
| C-27 | displacementScaleのデフォルト値は1 | E-15 | ○ |
| C-28 | Disney BRDFに基づく計算式 | **根拠なし（シェーダー未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- Disney BRDFおよびGGXマイクロファセットBRDFの実装詳細
  - 候補：シェーダーファイル（.glsl） / Three.js公式ドキュメント / Disneyペーパー参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な事実のみ記載
- 1: 中リスク - BRDF計算式の詳細はシェーダーコード確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] roughnessMap/metalnessMapのチャンネル使用がシェーダーと一致するか確認
- [ ] PMREMGenerator連携の処理フローを確認
- [ ] Material Browserでの表示確認（画面機能マッピングとの整合性）
