---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-MeshPhysicalMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshPhysicalMaterial.js` - 6-31行目（クラスドキュメント）
- E-02: `src/materials/MeshPhysicalMaterial.js` - 32行目（クラス定義、extends MeshStandardMaterial）
- E-03: `src/materials/MeshPhysicalMaterial.js` - 43-324行目（コンストラクタ）
- E-04: `src/materials/MeshPhysicalMaterial.js` - 54行目（isMeshPhysicalMaterial）
- E-05: `src/materials/MeshPhysicalMaterial.js` - 56-61行目（defines）
- E-06: `src/materials/MeshPhysicalMaterial.js` - 63行目（type）
- E-07: `src/materials/MeshPhysicalMaterial.js` - 73行目（anisotropyRotation）
- E-08: `src/materials/MeshPhysicalMaterial.js` - 83行目（anisotropyMap）
- E-09: `src/materials/MeshPhysicalMaterial.js` - 92行目（clearcoatMap）
- E-10: `src/materials/MeshPhysicalMaterial.js` - 100行目（clearcoatRoughness）
- E-11: `src/materials/MeshPhysicalMaterial.js` - 109行目（clearcoatRoughnessMap）
- E-12: `src/materials/MeshPhysicalMaterial.js` - 118行目（clearcoatNormalScale）
- E-13: `src/materials/MeshPhysicalMaterial.js` - 126行目（clearcoatNormalMap）
- E-14: `src/materials/MeshPhysicalMaterial.js` - 134行目（ior）
- E-15: `src/materials/MeshPhysicalMaterial.js` - 147-158行目（reflectivity getter/setter）
- E-16: `src/materials/MeshPhysicalMaterial.js` - 167行目（iridescenceMap）
- E-17: `src/materials/MeshPhysicalMaterial.js` - 176行目（iridescenceIOR）
- E-18: `src/materials/MeshPhysicalMaterial.js` - 185行目（iridescenceThicknessRange）
- E-19: `src/materials/MeshPhysicalMaterial.js` - 197行目（iridescenceThicknessMap）
- E-20: `src/materials/MeshPhysicalMaterial.js` - 205行目（sheenColor）
- E-21: `src/materials/MeshPhysicalMaterial.js` - 214行目（sheenColorMap）
- E-22: `src/materials/MeshPhysicalMaterial.js` - 222行目（sheenRoughness）
- E-23: `src/materials/MeshPhysicalMaterial.js` - 231行目（sheenRoughnessMap）
- E-24: `src/materials/MeshPhysicalMaterial.js` - 240行目（transmissionMap）
- E-25: `src/materials/MeshPhysicalMaterial.js` - 250行目（thickness）
- E-26: `src/materials/MeshPhysicalMaterial.js` - 259行目（thicknessMap）
- E-27: `src/materials/MeshPhysicalMaterial.js` - 269行目（attenuationDistance）
- E-28: `src/materials/MeshPhysicalMaterial.js` - 278行目（attenuationColor）
- E-29: `src/materials/MeshPhysicalMaterial.js` - 287行目（specularIntensity）
- E-30: `src/materials/MeshPhysicalMaterial.js` - 296行目（specularIntensityMap）
- E-31: `src/materials/MeshPhysicalMaterial.js` - 304行目（specularColor）
- E-32: `src/materials/MeshPhysicalMaterial.js` - 313行目（specularColorMap）
- E-33: `src/materials/MeshPhysicalMaterial.js` - 315-321行目（プライベートプロパティ）
- E-34: `src/materials/MeshPhysicalMaterial.js` - 326-478行目（getter/setter）
- E-35: `src/materials/MeshPhysicalMaterial.js` - 480-532行目（copyメソッド）
- E-36: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 38-39行目（関連画面）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshPhysicalMaterialはMeshStandardMaterialを継承 | E-02 | ○ |
| C-02 | クリアコート、異方性、虹色効果等の高度なPBR機能を提供 | E-01 | ○ |
| C-03 | isMeshPhysicalMaterialフラグがtrueで設定される | E-04 | ○ |
| C-04 | typeは'MeshPhysicalMaterial'で設定される | E-06 | ○ |
| C-05 | definesに{ 'STANDARD': '', 'PHYSICAL': '' }が設定される | E-05 | ○ |
| C-06 | anisotropyRotationのデフォルト値は0 | E-07 | ○ |
| C-07 | clearcoatRoughnessのデフォルト値は0.0 | E-10 | ○ |
| C-08 | iorのデフォルト値は1.5 | E-14 | ○ |
| C-09 | reflectivityはIORから計算される | E-15 | ○ |
| C-10 | reflectivity = clamp(2.5 * (ior - 1) / (ior + 1), 0, 1) | E-15 | ○ |
| C-11 | ior = (1 + 0.4 * reflectivity) / (1 - 0.4 * reflectivity) | E-15 | ○ |
| C-12 | iridescenceIORのデフォルト値は1.3 | E-17 | ○ |
| C-13 | iridescenceThicknessRangeのデフォルト値は[100, 400] | E-18 | ○ |
| C-14 | sheenColorのデフォルト値は0x000000 | E-20 | ○ |
| C-15 | sheenRoughnessのデフォルト値は1.0 | E-22 | ○ |
| C-16 | thicknessのデフォルト値は0 | E-25 | ○ |
| C-17 | attenuationDistanceのデフォルト値はInfinity | E-27 | ○ |
| C-18 | attenuationColorのデフォルト値は0xffffff | E-28 | ○ |
| C-19 | specularIntensityのデフォルト値は1.0 | E-29 | ○ |
| C-20 | specularColorのデフォルト値は0xffffff | E-31 | ○ |
| C-21 | _anisotropyの初期値は0 | E-33 | ○ |
| C-22 | _clearcoatの初期値は0 | E-33 | ○ |
| C-23 | _dispersionの初期値は0 | E-33 | ○ |
| C-24 | _iridescenceの初期値は0 | E-33 | ○ |
| C-25 | _sheenの初期値は0.0 | E-33 | ○ |
| C-26 | _transmissionの初期値は0 | E-33 | ○ |
| C-27 | anisotropyが0から非0に変化するとversion++ | E-34 | ○ |
| C-28 | clearcoatが0から非0に変化するとversion++ | E-34 | ○ |
| C-29 | iridescenceが0から非0に変化するとversion++ | E-34 | ○ |
| C-30 | dispersionが0から非0に変化するとversion++ | E-34 | ○ |
| C-31 | sheenが0から非0に変化するとversion++ | E-34 | ○ |
| C-32 | transmissionが0から非0に変化するとversion++ | E-34 | ○ |
| C-33 | copyメソッドで全プロパティをコピー可能 | E-35 | ○ |
| C-34 | Sidebar - Materialで設定可能 | E-36 | ○ |
| C-35 | Material Browserでプレビュー可能 | E-36 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] IOR-reflectivity連動の計算式がシェーダーと一致するか確認
- [ ] 各エフェクト（clearcoat, iridescence等）の有効化条件を確認
- [ ] Material Browserでの表示確認（画面機能マッピングとの整合性）
