---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-MeshToonMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshToonMaterial.js` - 6-11行目（クラスドキュメント）
- E-02: `src/materials/MeshToonMaterial.js` - 12行目（クラス定義）
- E-03: `src/materials/MeshToonMaterial.js` - 23-274行目（コンストラクタ）
- E-04: `src/materials/MeshToonMaterial.js` - 34行目（isMeshToonMaterial）
- E-05: `src/materials/MeshToonMaterial.js` - 36行目（defines）
- E-06: `src/materials/MeshToonMaterial.js` - 38行目（type）
- E-07: `src/materials/MeshToonMaterial.js` - 46行目（color）
- E-08: `src/materials/MeshToonMaterial.js` - 56行目（map）
- E-09: `src/materials/MeshToonMaterial.js` - 59-66行目（gradientMap）
- E-10: `src/materials/MeshToonMaterial.js` - 74-82行目（lightMap関連）
- E-11: `src/materials/MeshToonMaterial.js` - 91-101行目（aoMap関連）
- E-12: `src/materials/MeshToonMaterial.js` - 110-128行目（emissive関連）
- E-13: `src/materials/MeshToonMaterial.js` - 139-147行目（bumpMap関連）
- E-14: `src/materials/MeshToonMaterial.js` - 160-176行目（normalMap関連）
- E-15: `src/materials/MeshToonMaterial.js` - 188-209行目（displacementMap関連）
- E-16: `src/materials/MeshToonMaterial.js` - 224行目（alphaMap）
- E-17: `src/materials/MeshToonMaterial.js` - 232-262行目（wireframe関連）
- E-18: `src/materials/MeshToonMaterial.js` - 270行目（fog）
- E-19: `src/materials/MeshToonMaterial.js` - 272行目（setValues呼び出し）
- E-20: `src/materials/MeshToonMaterial.js` - 276-317行目（copyメソッド）
- E-21: `src/materials/Material.js` - 17行目（Materialクラス定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshToonMaterialはMaterialを継承している | E-02, E-21 | ○ |
| C-02 | トゥーンシェーディングを実現するマテリアル | E-01 | ○ |
| C-03 | isMeshToonMaterialフラグがtrueで設定される | E-04 | ○ |
| C-04 | typeは'MeshToonMaterial'で設定される | E-06 | ○ |
| C-05 | definesに{ 'TOON': '' }が設定される | E-05 | ○ |
| C-06 | colorのデフォルト値は0xffffff | E-07 | ○ |
| C-07 | gradientMapのデフォルト値はnull | E-09 | ○ |
| C-08 | gradientMapにはNearestFilter設定が必要 | E-09 | ○ |
| C-09 | lightMapIntensityのデフォルト値は1.0 | E-10 | ○ |
| C-10 | aoMapIntensityのデフォルト値は1.0 | E-11 | ○ |
| C-11 | emissiveのデフォルト値は0x000000 | E-12 | ○ |
| C-12 | emissiveIntensityのデフォルト値は1.0 | E-12 | ○ |
| C-13 | bumpScaleのデフォルト値は1 | E-13 | ○ |
| C-14 | normalMapTypeのデフォルト値はTangentSpaceNormalMap | E-14 | ○ |
| C-15 | normalScaleのデフォルト値は(1,1) | E-14 | ○ |
| C-16 | displacementScaleのデフォルト値は1 | E-15 | ○ |
| C-17 | displacementBiasのデフォルト値は0 | E-15 | ○ |
| C-18 | wireframeのデフォルト値はfalse | E-17 | ○ |
| C-19 | wireframeLinewidthのデフォルト値は1 | E-17 | ○ |
| C-20 | fogのデフォルト値はtrue | E-18 | ○ |
| C-21 | setValuesでパラメータを適用 | E-19 | ○ |
| C-22 | copyメソッドで全プロパティをコピー可能 | E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] gradientMapのNearestFilter設定がドキュメントと一致するか確認
- [ ] トゥーンシェーディングの段階数がシェーダーで確認可能か確認
- [ ] flatShadingプロパティが本当に存在しないことを確認
