---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-MeshNormalMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshNormalMaterial.js` - 5-10行目（クラスドキュメント）
- E-02: `src/materials/MeshNormalMaterial.js` - 11行目（クラス定義）
- E-03: `src/materials/MeshNormalMaterial.js` - 22-147行目（コンストラクタ）
- E-04: `src/materials/MeshNormalMaterial.js` - 33行目（isMeshNormalMaterial）
- E-05: `src/materials/MeshNormalMaterial.js` - 35行目（type）
- E-06: `src/materials/MeshNormalMaterial.js` - 46行目（bumpMap）
- E-07: `src/materials/MeshNormalMaterial.js` - 54行目（bumpScale）
- E-08: `src/materials/MeshNormalMaterial.js` - 67行目（normalMap）
- E-09: `src/materials/MeshNormalMaterial.js` - 75行目（normalMapType）
- E-10: `src/materials/MeshNormalMaterial.js` - 83行目（normalScale）
- E-11: `src/materials/MeshNormalMaterial.js` - 96行目（displacementMap）
- E-12: `src/materials/MeshNormalMaterial.js` - 106行目（displacementScale）
- E-13: `src/materials/MeshNormalMaterial.js` - 116行目（displacementBias）
- E-14: `src/materials/MeshNormalMaterial.js` - 124行目（wireframe）
- E-15: `src/materials/MeshNormalMaterial.js` - 129-135行目（wireframeLinewidth、WebGL/WebGPU制限）
- E-16: `src/materials/MeshNormalMaterial.js` - 143行目（flatShading）
- E-17: `src/materials/MeshNormalMaterial.js` - 145行目（setValues呼び出し）
- E-18: `src/materials/MeshNormalMaterial.js` - 149-171行目（copyメソッド）
- E-19: `src/materials/Material.js` - 17行目（Materialクラス定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshNormalMaterialはMaterialを継承している | E-02, E-19 | ○ |
| C-02 | 法線ベクトルをRGB色にマッピングする | E-01 | ○ |
| C-03 | isMeshNormalMaterialフラグがtrueで設定される | E-04 | ○ |
| C-04 | typeは'MeshNormalMaterial'で設定される | E-05 | ○ |
| C-05 | bumpMapのデフォルト値はnull | E-06 | ○ |
| C-06 | bumpScaleのデフォルト値は1 | E-07 | ○ |
| C-07 | normalMapのデフォルト値はnull | E-08 | ○ |
| C-08 | normalMapTypeのデフォルト値はTangentSpaceNormalMap | E-09 | ○ |
| C-09 | normalScaleのデフォルト値は(1,1) | E-10 | ○ |
| C-10 | displacementMapのデフォルト値はnull | E-11 | ○ |
| C-11 | displacementScaleのデフォルト値は1 | E-12 | ○ |
| C-12 | displacementBiasのデフォルト値は0 | E-13 | ○ |
| C-13 | wireframeのデフォルト値はfalse | E-14 | ○ |
| C-14 | wireframeLinewidthのデフォルト値は1 | E-15 | ○ |
| C-15 | WebGL/WebGPUではwireframeLinewidthは常に1ピクセル | E-15 | ○ |
| C-16 | flatShadingのデフォルト値はfalse | E-16 | ○ |
| C-17 | setValuesでパラメータを適用 | E-17 | ○ |
| C-18 | copyメソッドで全プロパティをコピー可能 | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 法線からRGB色への変換式がシェーダーと一致するか確認
- [ ] colorプロパティが本当に存在しないことを確認
- [ ] 画面機能マッピングへの登録が必要かどうか検討
