---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-MeshMatcapMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshMatcapMaterial.js` - 6-17行目（クラスドキュメント）
- E-02: `src/materials/MeshMatcapMaterial.js` - 18行目（クラス定義）
- E-03: `src/materials/MeshMatcapMaterial.js` - 29-204行目（コンストラクタ）
- E-04: `src/materials/MeshMatcapMaterial.js` - 40行目（isMeshMatcapMaterial）
- E-05: `src/materials/MeshMatcapMaterial.js` - 42行目（defines）
- E-06: `src/materials/MeshMatcapMaterial.js` - 44行目（type）
- E-07: `src/materials/MeshMatcapMaterial.js` - 52行目（color）
- E-08: `src/materials/MeshMatcapMaterial.js` - 57-60行目（matcap）
- E-09: `src/materials/MeshMatcapMaterial.js` - 70行目（map）
- E-10: `src/materials/MeshMatcapMaterial.js` - 81行目（bumpMap）
- E-11: `src/materials/MeshMatcapMaterial.js` - 89行目（bumpScale）
- E-12: `src/materials/MeshMatcapMaterial.js` - 102行目（normalMap）
- E-13: `src/materials/MeshMatcapMaterial.js` - 110行目（normalMapType）
- E-14: `src/materials/MeshMatcapMaterial.js` - 118行目（normalScale）
- E-15: `src/materials/MeshMatcapMaterial.js` - 131行目（displacementMap）
- E-16: `src/materials/MeshMatcapMaterial.js` - 141行目（displacementScale）
- E-17: `src/materials/MeshMatcapMaterial.js` - 151行目（displacementBias）
- E-18: `src/materials/MeshMatcapMaterial.js` - 166行目（alphaMap）
- E-19: `src/materials/MeshMatcapMaterial.js` - 174行目（wireframe）
- E-20: `src/materials/MeshMatcapMaterial.js` - 184行目（wireframeLinewidth）
- E-21: `src/materials/MeshMatcapMaterial.js` - 192行目（flatShading）
- E-22: `src/materials/MeshMatcapMaterial.js` - 200行目（fog）
- E-23: `src/materials/MeshMatcapMaterial.js` - 202行目（setValues呼び出し）
- E-24: `src/materials/MeshMatcapMaterial.js` - 207-241行目（copyメソッド）
- E-25: `src/materials/Material.js` - 17行目（Materialクラス定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshMatcapMaterialはMaterialを継承している | E-02, E-25 | ○ |
| C-02 | MatCapテクスチャを使用してシェーディングをエンコード | E-01 | ○ |
| C-03 | ライトに反応しない | E-01 | ○ |
| C-04 | シャドウキャストは可能だがセルフシャドウは不可 | E-01 | ○ |
| C-05 | isMeshMatcapMaterialフラグがtrueで設定される | E-04 | ○ |
| C-06 | typeは'MeshMatcapMaterial'で設定される | E-06 | ○ |
| C-07 | definesに{ 'MATCAP': '' }が設定される | E-05 | ○ |
| C-08 | colorのデフォルト値は0xffffff | E-07 | ○ |
| C-09 | matcapのデフォルト値はnull | E-08 | ○ |
| C-10 | mapのデフォルト値はnull | E-09 | ○ |
| C-11 | bumpMapのデフォルト値はnull | E-10 | ○ |
| C-12 | bumpScaleのデフォルト値は1 | E-11 | ○ |
| C-13 | normalMapTypeのデフォルト値はTangentSpaceNormalMap | E-13 | ○ |
| C-14 | normalScaleのデフォルト値は(1,1) | E-14 | ○ |
| C-15 | displacementScaleのデフォルト値は1 | E-16 | ○ |
| C-16 | displacementBiasのデフォルト値は0 | E-17 | ○ |
| C-17 | wireframeのデフォルト値はfalse | E-19 | ○ |
| C-18 | wireframeLinewidthのデフォルト値は1 | E-20 | ○ |
| C-19 | flatShadingのデフォルト値はfalse | E-21 | ○ |
| C-20 | fogのデフォルト値はtrue | E-22 | ○ |
| C-21 | setValuesでパラメータを適用 | E-23 | ○ |
| C-22 | copyメソッドで全プロパティをコピー可能 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] MatCapルックアップの計算式がシェーダーと一致するか確認
- [ ] シャドウキャスト動作の実際の挙動を確認
- [ ] 画面機能マッピングへの登録が必要かどうか検討
