---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-MeshDepthMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshDepthMaterial.js` - 4-10行目（クラスドキュメント）
- E-02: `src/materials/MeshDepthMaterial.js` - 11行目（クラス定義）
- E-03: `src/materials/MeshDepthMaterial.js` - 22-123行目（コンストラクタ）
- E-04: `src/materials/MeshDepthMaterial.js` - 33行目（isMeshDepthMaterial）
- E-05: `src/materials/MeshDepthMaterial.js` - 35行目（type）
- E-06: `src/materials/MeshDepthMaterial.js` - 40-43行目（depthPacking）
- E-07: `src/materials/MeshDepthMaterial.js` - 52行目（map）
- E-08: `src/materials/MeshDepthMaterial.js` - 67行目（alphaMap）
- E-09: `src/materials/MeshDepthMaterial.js` - 80行目（displacementMap）
- E-10: `src/materials/MeshDepthMaterial.js` - 90行目（displacementScale）
- E-11: `src/materials/MeshDepthMaterial.js` - 100行目（displacementBias）
- E-12: `src/materials/MeshDepthMaterial.js` - 108行目（wireframe）
- E-13: `src/materials/MeshDepthMaterial.js` - 113-119行目（wireframeLinewidth、WebGL/WebGPU制限）
- E-14: `src/materials/MeshDepthMaterial.js` - 121行目（setValues呼び出し）
- E-15: `src/materials/MeshDepthMaterial.js` - 125-144行目（copyメソッド）
- E-16: `src/materials/Material.js` - 17行目（Materialクラス定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshDepthMaterialはMaterialを継承している | E-02, E-16 | ○ |
| C-02 | 深度値で描画する（白=近い、黒=遠い） | E-01 | ○ |
| C-03 | isMeshDepthMaterialフラグがtrueで設定される | E-04 | ○ |
| C-04 | typeは'MeshDepthMaterial'で設定される | E-05 | ○ |
| C-05 | depthPackingのデフォルト値はBasicDepthPacking | E-06 | ○ |
| C-06 | depthPackingで複数のパッキングタイプをサポート | E-06 | ○ |
| C-07 | mapのデフォルト値はnull | E-07 | ○ |
| C-08 | alphaMapのデフォルト値はnull | E-08 | ○ |
| C-09 | displacementMapのデフォルト値はnull | E-09 | ○ |
| C-10 | displacementScaleのデフォルト値は1 | E-10 | ○ |
| C-11 | displacementBiasのデフォルト値は0 | E-11 | ○ |
| C-12 | wireframeのデフォルト値はfalse | E-12 | ○ |
| C-13 | wireframeLinewidthのデフォルト値は1 | E-13 | ○ |
| C-14 | WebGL/WebGPUではwireframeLinewidthは常に1ピクセル | E-13 | ○ |
| C-15 | setValuesでパラメータを適用 | E-14 | ○ |
| C-16 | copyメソッドで全プロパティをコピー可能 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 深度パッキングの計算式がシェーダーと一致するか確認
- [ ] シャドウマップ生成での使用方法を確認
- [ ] RGBADepthPackingとBasicDepthPackingの精度差を確認
