---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-MeshDistanceMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/MeshDistanceMaterial.js` - 3-12行目（クラスドキュメント）
- E-02: `src/materials/MeshDistanceMaterial.js` - 14行目（クラス定義）
- E-03: `src/materials/MeshDistanceMaterial.js` - 25-99行目（コンストラクタ）
- E-04: `src/materials/MeshDistanceMaterial.js` - 36行目（isMeshDistanceMaterial）
- E-05: `src/materials/MeshDistanceMaterial.js` - 38行目（type）
- E-06: `src/materials/MeshDistanceMaterial.js` - 47行目（map）
- E-07: `src/materials/MeshDistanceMaterial.js` - 62行目（alphaMap）
- E-08: `src/materials/MeshDistanceMaterial.js` - 75行目（displacementMap）
- E-09: `src/materials/MeshDistanceMaterial.js` - 85行目（displacementScale）
- E-10: `src/materials/MeshDistanceMaterial.js` - 95行目（displacementBias）
- E-11: `src/materials/MeshDistanceMaterial.js` - 97行目（setValues呼び出し）
- E-12: `src/materials/MeshDistanceMaterial.js` - 101-115行目（copyメソッド）
- E-13: `src/materials/Material.js` - 17行目（Materialクラス定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MeshDistanceMaterialはMaterialを継承している | E-02, E-13 | ○ |
| C-02 | ポイントライトのシャドウマップ実装に内部的に使用 | E-01 | ○ |
| C-03 | Object3D.customDistanceMaterialでカスタマイズ可能 | E-01 | ○ |
| C-04 | isMeshDistanceMaterialフラグがtrueで設定される | E-04 | ○ |
| C-05 | typeは'MeshDistanceMaterial'で設定される | E-05 | ○ |
| C-06 | mapのデフォルト値はnull | E-06 | ○ |
| C-07 | alphaMapのデフォルト値はnull | E-07 | ○ |
| C-08 | displacementMapのデフォルト値はnull | E-08 | ○ |
| C-09 | displacementScaleのデフォルト値は1 | E-09 | ○ |
| C-10 | displacementBiasのデフォルト値は0 | E-10 | ○ |
| C-11 | wireframeプロパティを持たない | E-03 | ○ |
| C-12 | setValuesでパラメータを適用 | E-11 | ○ |
| C-13 | copyメソッドで全プロパティをコピー可能 | E-12 | ○ |
| C-14 | 透明部分のシャドウ制御にmap/alphaMapを使用 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ポイントライトシャドウでの使用方法をレンダラーコードで確認
- [ ] customDistanceMaterialの動作を確認
- [ ] キューブマップシャドウマップ生成フローを確認
