---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Clock.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/Clock.js` - Clockクラスのソースコード
- E-02: `src/core/Timer.js` - 推奨代替クラスのソースコード
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Clockはr183以降で非推奨 | E-01 (6-7行目: `@deprecated since r183`, 61行目: warn出力) | ○ |
| C-02 | autoStartのデフォルトはtrue | E-01 (17行目: `autoStart = true`) | ○ |
| C-03 | startTimeの初期値は0 | E-01 (34行目: `this.startTime = 0`) | ○ |
| C-04 | oldTimeの初期値は0 | E-01 (43行目: `this.oldTime = 0`) | ○ |
| C-05 | elapsedTimeの初期値は0 | E-01 (51行目: `this.elapsedTime = 0`) | ○ |
| C-06 | runningの初期値はfalse | E-01 (59行目: `this.running = false`) | ○ |
| C-07 | start()でstartTime = performance.now() | E-01 (71行目: `this.startTime = performance.now()`) | ○ |
| C-08 | start()でrunning = true | E-01 (75行目: `this.running = true`) | ○ |
| C-09 | stop()でgetElapsedTime()が呼ばれる | E-01 (84行目: `this.getElapsedTime()`) | ○ |
| C-10 | stop()でautoStart = false | E-01 (86行目: `this.autoStart = false`) | ○ |
| C-11 | getElapsedTime()はgetDelta()を呼んでelapsedTimeを返す | E-01 (97-98行目) | ○ |
| C-12 | getDelta()でautoStart && !runningの場合、start()を呼んで0を返す | E-01 (111-115行目) | ○ |
| C-13 | getDelta()で(newTime - oldTime) / 1000でデルタ計算 | E-01 (122行目: `diff = ( newTime - this.oldTime ) / 1000`) | ○ |
| C-14 | 関連画面として1画面が該当 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: すべての主張がソースコードから直接確認可能
- **注意**: このクラスは非推奨のため、新規実装ではTimerクラスの使用を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 非推奨警告が正しく出力されることを確認
- [ ] autoStart機能の動作が正確か確認
- [ ] stop()後のautoStart無効化が正確か確認
- [ ] 関連画面の一覧が画面機能マッピングと一致しているか確認
