---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-LineDashedMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/LineDashedMaterial.js` - 3-17行目（クラスドキュメント）
- E-02: `src/materials/LineDashedMaterial.js` - 19行目（クラス定義）
- E-03: `src/materials/LineDashedMaterial.js` - 30-70行目（コンストラクタ）
- E-04: `src/materials/LineDashedMaterial.js` - 41行目（isLineDashedMaterial）
- E-05: `src/materials/LineDashedMaterial.js` - 42行目（type）
- E-06: `src/materials/LineDashedMaterial.js` - 44-50行目（scale）
- E-07: `src/materials/LineDashedMaterial.js` - 52-58行目（dashSize）
- E-08: `src/materials/LineDashedMaterial.js` - 60-66行目（gapSize）
- E-09: `src/materials/LineDashedMaterial.js` - 68行目（setValues呼び出し）
- E-10: `src/materials/LineDashedMaterial.js` - 72-82行目（copyメソッド）
- E-11: `src/materials/LineBasicMaterial.js` - 15行目（LineBasicMaterialクラス定義）
- E-12: `src/materials/Material.js` - 17行目（Materialクラス定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LineDashedMaterialはLineBasicMaterialを継承している | E-02, E-11 | ○ |
| C-02 | 破線スタイルでラインプリミティブをレンダリング | E-01 | ○ |
| C-03 | isLineDashedMaterialフラグがtrueで設定される | E-04 | ○ |
| C-04 | typeは'LineDashedMaterial'で設定される | E-05 | ○ |
| C-05 | scaleのデフォルト値は1 | E-06 | ○ |
| C-06 | dashSizeのデフォルト値は3 | E-07 | ○ |
| C-07 | gapSizeのデフォルト値は1 | E-08 | ○ |
| C-08 | setValuesでパラメータを適用 | E-09 | ○ |
| C-09 | copyメソッドで全プロパティをコピー可能 | E-10 | ○ |
| C-10 | 親クラスのcopyを呼び出す | E-10 | ○ |
| C-11 | scale、dashSize、gapSizeをコピー | E-10 | ○ |
| C-12 | LineBasicMaterialのすべてのプロパティを継承 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] computeLineDistances()の呼び出し要件を確認
- [ ] ダッシュパターン計算のシェーダー実装を確認
- [ ] scale、dashSize、gapSizeの組み合わせ効果を確認
