---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-PointsMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **シェーダー内のサイズ減衰計算式**：シェーダーコード未確認
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/PointsMaterial.js` - PointsMaterialクラス実装
- E-02: `src/materials/Material.js` - Material基底クラス実装
- E-03: `src/math/Color.js` - Colorクラス実装（暗黙の参照）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PointsMaterialはMaterialを継承している | E-01: 29行目 `class PointsMaterial extends Material` | ○ |
| C-02 | isPointsMaterialフラグがtrueで初期化される | E-01: 51行目 `this.isPointsMaterial = true` | ○ |
| C-03 | type は 'PointsMaterial' | E-01: 53行目 `this.type = 'PointsMaterial'` | ○ |
| C-04 | colorのデフォルトは白（0xffffff） | E-01: 61行目 `this.color = new Color( 0xffffff )` | ○ |
| C-05 | mapのデフォルトはnull | E-01: 71行目 `this.map = null` | ○ |
| C-06 | alphaMapのデフォルトはnull | E-01: 86行目 `this.alphaMap = null` | ○ |
| C-07 | sizeのデフォルトは1 | E-01: 96行目 `this.size = 1` | ○ |
| C-08 | sizeAttenuationのデフォルトはtrue | E-01: 104行目 `this.sizeAttenuation = true` | ○ |
| C-09 | fogのデフォルトはtrue | E-01: 112行目 `this.fog = true` | ○ |
| C-10 | setValuesでパラメータが適用される | E-01: 114行目 `this.setValues( parameters )` | ○ |
| C-11 | copyメソッドが実装されている | E-01: 118-135行目 copyメソッド定義 | ○ |
| C-12 | alphaMapは緑チャンネルが使用される（DXT圧縮互換） | E-01: 73-79行目 JSDocコメント | ○ |
| C-13 | sizeはハードウェア制限でクランプされる可能性 | E-01: 91行目 JSDocコメント `gl.ALIASED_POINT_SIZE_RANGE` | ○ |
| C-14 | sizeAttenuationはPerspectiveCameraでのみ有効 | E-01: 99行目 JSDocコメント `perspective camera only` | ○ |
| C-15 | Material基底クラスにsetValuesメソッドがある | E-02: 555-594行目 setValuesメソッド | ○ |
| C-16 | Material基底クラスにcopyメソッドがある | E-02: 901-979行目 copyメソッド | ○ |
| C-17 | 機能一覧に点群描画用マテリアルとして記載 | E-04: 62行目 PointsMaterial定義 | ○ |
| C-18 | シェーダー内でサイズ減衰が計算される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- シェーダー内のサイズ減衰計算式の具体的な実装
  - 候補：`src/renderers/shaders/ShaderLib/points.glsl.js` / シェーダーチャンク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なプロパティ定義はすべてソースコードで確認済み
- 1: 中リスク - シェーダー内の計算ロジックは未検証

## 6) レビュアーチェックリスト（最小）
- [ ] PointsMaterial.jsの行番号が設計書と一致しているか確認
- [ ] シェーダー内のサイズ減衰計算を実際のシェーダーコードで検証
- [ ] パフォーマンス要件の妥当性を検証
