---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：62-SpriteMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/SpriteMaterial.js` - SpriteMaterialクラス実装
- E-02: `src/materials/Material.js` - Material基底クラス実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SpriteMaterialはMaterialを継承している | E-01: 18行目 `class SpriteMaterial extends Material` | ○ |
| C-02 | isSpriteMaterialフラグがtrueで初期化される | E-01: 40行目 `this.isSpriteMaterial = true` | ○ |
| C-03 | type は 'SpriteMaterial' | E-01: 42行目 `this.type = 'SpriteMaterial'` | ○ |
| C-04 | colorのデフォルトは白（0xffffff） | E-01: 50行目 `this.color = new Color( 0xffffff )` | ○ |
| C-05 | mapのデフォルトはnull | E-01: 60行目 `this.map = null` | ○ |
| C-06 | alphaMapのデフォルトはnull | E-01: 75行目 `this.alphaMap = null` | ○ |
| C-07 | rotationのデフォルトは0 | E-01: 83行目 `this.rotation = 0` | ○ |
| C-08 | sizeAttenuationのデフォルトはtrue | E-01: 91行目 `this.sizeAttenuation = true` | ○ |
| C-09 | transparentのデフォルトはtrue（基底クラスと異なる） | E-01: 100行目 `this.transparent = true` | ○ |
| C-10 | fogのデフォルトはtrue | E-01: 108行目 `this.fog = true` | ○ |
| C-11 | setValuesでパラメータが適用される | E-01: 110行目 `this.setValues( parameters )` | ○ |
| C-12 | copyメソッドが実装されている | E-01: 114-132行目 copyメソッド定義 | ○ |
| C-13 | alphaMapは緑チャンネルが使用される（DXT圧縮互換） | E-01: 64-70行目 JSDocコメント | ○ |
| C-14 | sizeAttenuationはPerspectiveCameraでのみ有効 | E-01: 86行目 JSDocコメント `perspective camera only` | ○ |
| C-15 | rotationの単位はラジアン | E-01: 79行目 JSDocコメント `in radians` | ○ |
| C-16 | 機能一覧にスプライト用マテリアルとして記載 | E-03: 63行目 SpriteMaterial定義 | ○ |
| C-17 | Menubar - Addでスプライト追加の補助機能として関連 | E-04: 66行目 Sprite追加時の機能関連 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主要な主張についてソースコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり、信頼度1.00

## 6) レビュアーチェックリスト（最小）
- [ ] SpriteMaterial.jsの行番号が設計書と一致しているか確認
- [ ] Spriteオブジェクトとの連携動作を実機で検証
- [ ] sizeAttenuation効果をPerspectiveCamera/OrthographicCameraで比較検証
