---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：63-ShaderMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **シェーダーコンパイルエラー処理**：WebGLProgram.js未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/ShaderMaterial.js` - ShaderMaterialクラス実装
- E-02: `src/materials/Material.js` - Material基底クラス実装
- E-03: `src/renderers/shaders/ShaderChunk/default_vertex.glsl.js` - デフォルト頂点シェーダー（暗黙参照）
- E-04: `src/renderers/shaders/ShaderChunk/default_fragment.glsl.js` - デフォルトフラグメントシェーダー（暗黙参照）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShaderMaterialはMaterialを継承している | E-01: 39行目 `class ShaderMaterial extends Material` | ○ |
| C-02 | isShaderMaterialフラグがtrueで初期化される | E-01: 61行目 `this.isShaderMaterial = true` | ○ |
| C-03 | type は 'ShaderMaterial' | E-01: 63行目 `this.type = 'ShaderMaterial'` | ○ |
| C-04 | definesのデフォルトは空オブジェクト | E-01: 83行目 `this.defines = {}` | ○ |
| C-05 | uniformsのデフォルトは空オブジェクト | E-01: 107行目 `this.uniforms = {}` | ○ |
| C-06 | uniformsGroupsのデフォルトは空配列 | E-01: 114行目 `this.uniformsGroups = []` | ○ |
| C-07 | vertexShaderのデフォルトはdefault_vertex | E-01: 121行目 `this.vertexShader = default_vertex` | ○ |
| C-08 | fragmentShaderのデフォルトはdefault_fragment | E-01: 128行目 `this.fragmentShader = default_fragment` | ○ |
| C-09 | linewidthのデフォルトは1 | E-01: 139行目 `this.linewidth = 1` | ○ |
| C-10 | wireframeのデフォルトはfalse | E-01: 147行目 `this.wireframe = false` | ○ |
| C-11 | wireframeLinewidthのデフォルトは1 | E-01: 158行目 `this.wireframeLinewidth = 1` | ○ |
| C-12 | fogのデフォルトはfalse | E-01: 180行目 `this.fog = false` | ○ |
| C-13 | lightsのデフォルトはfalse | E-01: 189行目 `this.lights = false` | ○ |
| C-14 | clippingのデフォルトはfalse | E-01: 198行目 `this.clipping = false` | ○ |
| C-15 | forceSinglePassのデフォルトはtrue（オーバーライド） | E-01: 206行目 `this.forceSinglePass = true` | ○ |
| C-16 | extensionsプロパティが存在（clipCullDistance, multiDraw） | E-01: 216-219行目 extensions定義 | ○ |
| C-17 | defaultAttributeValuesが存在（color, uv, uv1） | E-01: 232-236行目 defaultAttributeValues定義 | ○ |
| C-18 | uniformsNeedUpdateプロパティが存在 | E-01: 254行目 `this.uniformsNeedUpdate = false` | ○ |
| C-19 | glslVersionプロパティが存在 | E-01: 262行目 `this.glslVersion = null` | ○ |
| C-20 | copyメソッドでuniformsをcloneUniformsでコピー | E-01: 279行目 `this.uniforms = cloneUniforms( source.uniforms )` | ○ |
| C-21 | toJSONメソッドでシェーダーコードをシリアライズ | E-01: 380-381行目 vertexShader/fragmentShaderのシリアライズ | ○ |
| C-22 | WebGLRendererでのみ使用可能 | E-01: 14行目 JSDocコメント | ○ |
| C-23 | Script Editorでカスタムシェーダー編集が可能 | E-06: 74行目 Script Editor - ShaderMaterial関連 | ○ |
| C-24 | シェーダーコンパイルエラー時にコンソール出力 | **根拠なし** - WebGLProgram.js未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- シェーダーコンパイルエラー処理の詳細
  - 候補：`src/renderers/webgl/WebGLProgram.js` / `src/renderers/webgl/WebGLShader.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なプロパティ定義はすべてソースコードで確認済み
- 1: 中リスク - エラー処理の詳細は未検証

## 6) レビュアーチェックリスト（最小）
- [ ] ShaderMaterial.jsの行番号が設計書と一致しているか確認
- [ ] WebGLProgram.jsでのシェーダーコンパイルエラー処理を検証
- [ ] fog=true時のフォグユニフォームマージ処理を検証
- [ ] lights=true時のライティングユニフォーム処理を検証
