---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-RawShaderMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/RawShaderMaterial.js` - RawShaderMaterialクラス実装
- E-02: `src/materials/ShaderMaterial.js` - 親クラス（ShaderMaterial）実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RawShaderMaterialはShaderMaterialを継承している | E-01: 12行目 `class RawShaderMaterial extends ShaderMaterial` | ○ |
| C-02 | isRawShaderMaterialフラグがtrueで初期化される | E-01: 34行目 `this.isRawShaderMaterial = true` | ○ |
| C-03 | type は 'RawShaderMaterial' | E-01: 36行目 `this.type = 'RawShaderMaterial'` | ○ |
| C-04 | コンストラクタでsuper(parameters)を呼び出す | E-01: 25行目 `super( parameters )` | ○ |
| C-05 | WebGLRendererでのみ使用可能 | E-01: 8行目 JSDocコメント | ○ |
| C-06 | 組み込み属性・ユニフォームが自動追加されない | E-01: 3-6行目 JSDocコメント | ○ |
| C-07 | ShaderMaterialの全機能を継承 | E-01: 12行目 extends宣言、E-02: 親クラス実装 | ○ |
| C-08 | 43行という簡潔な実装 | E-01: ファイル全体（43行） | ○ |
| C-09 | 機能一覧に組み込みシェーダー不使用として記載 | E-03: 65行目 RawShaderMaterial定義 | ○ |
| C-10 | Script Editorでの編集が可能 | E-04: 75行目 Script Editor - RawShaderMaterial関連 | ○ |
| C-11 | パラメータはsuper()に委譲される | E-01: 25行目、E-02: コンストラクタ実装 | ○ |
| C-12 | ShaderMaterialとの違いは組み込み定義追加の有無のみ | E-01: JSDocコメント、継承構造 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - RawShaderMaterialは非常に簡潔な実装のため、すべての主張が確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり、信頼度1.00
- 実装が43行と非常に簡潔なため、検証範囲が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] RawShaderMaterial.jsの行番号が設計書と一致しているか確認
- [ ] WebGLProgram.jsでのisRawShaderMaterial判定処理を検証
- [ ] 実際にRawShaderMaterialで組み込み定義が追加されないことを動作検証
