---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-ShadowMaterial

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/materials/ShadowMaterial.js` - ShadowMaterialクラス実装
- E-02: `src/materials/Material.js` - Material基底クラス実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShadowMaterialはMaterialを継承している | E-01: 22行目 `class ShadowMaterial extends Material` | ○ |
| C-02 | isShadowMaterialフラグがtrueで初期化される | E-01: 44行目 `this.isShadowMaterial = true` | ○ |
| C-03 | type は 'ShadowMaterial' | E-01: 46行目 `this.type = 'ShadowMaterial'` | ○ |
| C-04 | colorのデフォルトは黒（0x000000） | E-01: 54行目 `this.color = new Color( 0x000000 )` | ○ |
| C-05 | transparentのデフォルトはtrue | E-01: 63行目 `this.transparent = true` | ○ |
| C-06 | fogのデフォルトはtrue | E-01: 71行目 `this.fog = true` | ○ |
| C-07 | setValuesでパラメータが適用される | E-01: 73行目 `this.setValues( parameters )` | ○ |
| C-08 | copyメソッドが実装されている | E-01: 77-87行目 copyメソッド定義 | ○ |
| C-09 | copyメソッドでcolorがコピーされる | E-01: 81行目 `this.color.copy( source.color )` | ○ |
| C-10 | copyメソッドでfogがコピーされる | E-01: 83行目 `this.fog = source.fog` | ○ |
| C-11 | JSDocで「影を受け取りつつ透明」と説明 | E-01: 5-6行目 JSDocコメント | ○ |
| C-12 | 使用例でreceiveShadow=trueを設定 | E-01: 16行目 JSDocコメントの例 | ○ |
| C-13 | 使用例でPlaneGeometryを使用 | E-01: 8行目 JSDocコメントの例 | ○ |
| C-14 | 機能一覧に影のみ描画マテリアルとして記載 | E-03: 66行目 ShadowMaterial定義 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張についてソースコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり、信頼度1.00
- 実装が92行と簡潔なため、検証範囲が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] ShadowMaterial.jsの行番号が設計書と一致しているか確認
- [ ] receiveShadow=true設定時の影表示を実機検証
- [ ] シャドウマップ有効時の動作を確認
