---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-DirectionalLight

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/lights/DirectionalLight.js` - DirectionalLightクラス実装
- E-02: `src/lights/DirectionalLightShadow.js` - DirectionalLightShadowクラス実装
- E-03: `src/lights/Light.js` - Light親クラス実装
- E-04: `src/core/Object3D.js` - Object3D親クラス実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectionalLightはLightを継承している | E-01: 32行目 `class DirectionalLight extends Light` | ○ |
| C-02 | isDirectionalLightフラグがtrueで初期化される | E-01: 51行目 `this.isDirectionalLight = true` | ○ |
| C-03 | type は 'DirectionalLight' | E-01: 53行目 `this.type = 'DirectionalLight'` | ○ |
| C-04 | positionのデフォルトはDEFAULT_UP (0,1,0) | E-01: 55行目 `this.position.copy( Object3D.DEFAULT_UP )` | ○ |
| C-05 | updateMatrix()で行列更新 | E-01: 56行目 `this.updateMatrix()` | ○ |
| C-06 | targetは新しいObject3D | E-01: 70行目 `this.target = new Object3D()` | ○ |
| C-07 | shadowはDirectionalLightShadow | E-01: 77行目 `this.shadow = new DirectionalLightShadow()` | ○ |
| C-08 | dispose()でshadow.dispose()を呼び出す | E-01: 85行目 `this.shadow.dispose()` | ○ |
| C-09 | copy()でtargetをクローン | E-01: 93行目 `this.target = source.target.clone()` | ○ |
| C-10 | copy()でshadowをクローン | E-01: 94行目 `this.shadow = source.shadow.clone()` | ○ |
| C-11 | toJSON()でshadowをシリアライズ | E-01: 104行目 `data.object.shadow = this.shadow.toJSON()` | ○ |
| C-12 | toJSON()でtarget.uuidをシリアライズ | E-01: 105行目 `data.object.target = this.target.uuid` | ○ |
| C-13 | 影生成可能 | E-01: 22行目 JSDocコメント | ○ |
| C-14 | rotationは光の方向に影響しない | E-01: 12-15行目 JSDocコメント | ○ |
| C-15 | 方向はposition→targetで決定 | E-01: 17-18行目 JSDocコメント | ○ |
| C-16 | DirectionalLightShadowは正射影カメラを使用 | E-02: 16行目 `new OrthographicCamera( -5, 5, 5, -5, 0.5, 500 )` | ○ |
| C-17 | 114行の実装 | E-01: ファイル全体（114行） | ○ |
| C-18 | 機能一覧に平行光源として記載 | E-05: 69行目 DirectionalLight定義 | ○ |
| C-19 | Menubar - Addで追加可能 | E-06: 59行目 DirectionalLight関連 | ○ |
| C-20 | Menubar - Viewでヘルパー表示切替 | E-06: 71行目 DirectionalLightHelper関連 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張についてソースコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり、信頼度1.00

## 6) レビュアーチェックリスト（最小）
- [ ] DirectionalLight.jsの行番号が設計書と一致しているか確認
- [ ] シャドウマップ生成を実機検証
- [ ] target追加時の動作を確認
- [ ] Object3D.DEFAULT_UPの値を確認
