---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Timer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/core/Timer.js` - Timerクラスのソースコード
- E-02: `src/core/Clock.js` - 旧クラス（比較用）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _startTimeはperformance.now()で初期化 | E-01 (24行目: `this._startTime = performance.now()`) | ○ |
| C-02 | _timescaleのデフォルトは1 | E-01 (29行目: `this._timescale = 1`) | ○ |
| C-03 | _documentのデフォルトはnull | E-01 (31行目: `this._document = null`) | ○ |
| C-04 | connect()でvisibilitychangeイベントを登録 | E-01 (53行目: `document.addEventListener( 'visibilitychange', this._pageVisibilityHandler, false )`) | ○ |
| C-05 | disconnect()でイベントリスナーを解除 | E-01 (66行目: `this._document.removeEventListener( 'visibilitychange', this._pageVisibilityHandler )`) | ○ |
| C-06 | getDelta()は_delta / 1000を返す | E-01 (82行目: `return this._delta / 1000`) | ○ |
| C-07 | getElapsed()は_elapsed / 1000を返す | E-01 (93行目: `return this._elapsed / 1000`) | ○ |
| C-08 | setTimescale()は_timescaleを設定してthisを返す | E-01 (117行目: `this._timescale = timescale`) | ○ |
| C-09 | reset()で_currentTimeをリセット | E-01 (130行目: `this._currentTime = performance.now() - this._startTime`) | ○ |
| C-10 | dispose()はdisconnect()を呼ぶ | E-01 (142行目: `this.disconnect()`) | ○ |
| C-11 | update()でhiddenの場合_delta = 0 | E-01 (158-160行目: `if ( this._pageVisibilityHandler !== null && this._document.hidden === true ) { this._delta = 0 }`) | ○ |
| C-12 | update()で_delta = diff * _timescale | E-01 (167行目: `this._delta = ( this._currentTime - this._previousTime ) * this._timescale`) | ○ |
| C-13 | update()で_elapsed += _delta | E-01 (168行目: `this._elapsed += this._delta`) | ○ |
| C-14 | handleVisibilityChange()でhidden=falseならreset() | E-01 (180行目: `if ( this._document.hidden === false ) this.reset()`) | ○ |
| C-15 | update()はthisを返す | E-01 (172行目: `return this`) | ○ |
| C-16 | 関連画面として1画面が該当 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張に根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Page Visibility APIの動作が正確か確認
- [ ] timescale適用のタイミングが正確か確認
- [ ] reset()のタイミングが正確か確認（visibilitychange時）
- [ ] 関連画面の一覧が画面機能マッピングと一致しているか確認
