---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-SpotLight

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/lights/SpotLight.js` - SpotLightクラス実装
- E-02: `src/lights/SpotLightShadow.js` - SpotLightShadowクラス実装
- E-03: `src/lights/Light.js` - Light親クラス実装
- E-04: `src/core/Object3D.js` - Object3D親クラス実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SpotLightはLightを継承している | E-01: 27行目 `class SpotLight extends Light` | ○ |
| C-02 | isSpotLightフラグがtrueで初期化される | E-01: 50行目 `this.isSpotLight = true` | ○ |
| C-03 | type は 'SpotLight' | E-01: 52行目 `this.type = 'SpotLight'` | ○ |
| C-04 | positionのデフォルトはDEFAULT_UP (0,1,0) | E-01: 54行目 `this.position.copy( Object3D.DEFAULT_UP )` | ○ |
| C-05 | updateMatrix()で行列更新 | E-01: 55行目 `this.updateMatrix()` | ○ |
| C-06 | targetは新しいObject3D | E-01: 69行目 `this.target = new Object3D()` | ○ |
| C-07 | distanceのデフォルトは0 | E-01: 39行目 `distance = 0` | ○ |
| C-08 | angleのデフォルトはMath.PI/3 | E-01: 39行目 `angle = Math.PI / 3` | ○ |
| C-09 | penumbraのデフォルトは0 | E-01: 39行目 `penumbra = 0` | ○ |
| C-10 | decayのデフォルトは2 | E-01: 39行目 `decay = 2` | ○ |
| C-11 | mapのデフォルトはnull | E-01: 116行目 `this.map = null` | ○ |
| C-12 | shadowはSpotLightShadow | E-01: 123行目 `this.shadow = new SpotLightShadow()` | ○ |
| C-13 | powerはintensity * πで計算 | E-01: 137行目 `return this.intensity * Math.PI` | ○ |
| C-14 | power setterはintensity = power / π | E-01: 144行目 `this.intensity = power / Math.PI` | ○ |
| C-15 | dispose()でshadow.dispose()を呼び出す | E-01: 152行目 `this.shadow.dispose()` | ○ |
| C-16 | copy()でdistanceをコピー | E-01: 160行目 `this.distance = source.distance` | ○ |
| C-17 | copy()でangleをコピー | E-01: 161行目 `this.angle = source.angle` | ○ |
| C-18 | copy()でpenumbraをコピー | E-01: 162行目 `this.penumbra = source.penumbra` | ○ |
| C-19 | copy()でdecayをコピー | E-01: 163行目 `this.decay = source.decay` | ○ |
| C-20 | copy()でtargetをクローン | E-01: 165行目 `this.target = source.target.clone()` | ○ |
| C-21 | copy()でmapをコピー | E-01: 166行目 `this.map = source.map` | ○ |
| C-22 | copy()でshadowをクローン | E-01: 167行目 `this.shadow = source.shadow.clone()` | ○ |
| C-23 | toJSON()でtarget.uuidをシリアライズ | E-01: 182行目 `data.object.target = this.target.uuid` | ○ |
| C-24 | toJSON()でmapをシリアライズ | E-01: 184行目 mapのシリアライズ | ○ |
| C-25 | 影生成可能 | E-01: 9行目 JSDocコメント | ○ |
| C-26 | 円錐形に光を放射 | E-01: 6-7行目 JSDocコメント | ○ |
| C-27 | SpotLightShadowはPerspectiveCameraを使用 | E-02: 17行目 `new PerspectiveCamera( 50, 1, 0.5, 500 )` | ○ |
| C-28 | SpotLightShadowはupdateMatricesでFOVを自動計算 | E-02: 51行目 `camera.fov = fov` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張についてソースコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり、信頼度1.00

## 6) レビュアーチェックリスト（最小）
- [ ] SpotLight.jsの行番号が設計書と一致しているか確認
- [ ] シャドウマップ生成を実機検証
- [ ] target追加時の動作を確認
- [ ] penumbraによるソフトシャドウ効果を確認
- [ ] mapプロパティのプロジェクター効果を確認
- [ ] power/intensityの変換式（π係数）が正しいか確認
